/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.connection;

import java.util.Map;

public final class ConnectionParameters {
    private final String type;
    private final String url;
    private final String authentication;
    private final int initialPoolSize;
    private final int maxPoolSize;
    private final long poolTimeout;
    private final String referral;
    private final Map<String, String> extendedConf;
    private final boolean schemaEnabled;
    private final boolean isTlsEnabled;
    private final boolean isSslEnabled;
    private final String trustStorePath;
    private final String trustStorePassword;

    public String getType() {
        return this.type;
    }

    public boolean isTlsEnabled() {
        return this.isTlsEnabled;
    }

    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public Map<String, String> getExtendedConf() {
        return this.extendedConf;
    }

    public String getReferral() {
        return this.referral;
    }

    public long getPoolTimeout() {
        return this.poolTimeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSslEnabled() {
        return this.isSslEnabled;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    private ConnectionParameters(ConnectionParametersBuilder connectionParametersBuilder) {
        this.type = connectionParametersBuilder.c;
        this.url = connectionParametersBuilder.d;
        this.authentication = connectionParametersBuilder.e;
        this.initialPoolSize = connectionParametersBuilder.initialPoolSize;
        this.maxPoolSize = connectionParametersBuilder.maxPoolSize;
        this.poolTimeout = connectionParametersBuilder.poolTimeout;
        this.referral = connectionParametersBuilder.referral;
        this.extendedConf = connectionParametersBuilder.extendedConf;
        this.schemaEnabled = connectionParametersBuilder.schemaEnabled;
        this.isTlsEnabled = connectionParametersBuilder.f;
        this.isSslEnabled = connectionParametersBuilder.b;
        this.trustStorePath = connectionParametersBuilder.trustStorePath;
        this.trustStorePassword = connectionParametersBuilder.trustStorePassword;
    }

    public static class ConnectionParametersBuilder {
        private boolean b;
        private final String c;
        private final String d;
        private final String e;
        private int initialPoolSize;
        private int maxPoolSize;
        private long poolTimeout;
        private String referral;
        private Map<String, String> extendedConf;
        private boolean schemaEnabled;
        private boolean f;
        private String trustStorePath;
        private String trustStorePassword;

        public ConnectionParametersBuilder(String string, String string2, String string3) {
            this.c = string;
            this.d = string2;
            this.e = string3;
        }

        public ConnectionParametersBuilder setInitialPoolSize(int n) {
            this.initialPoolSize = n;
            return this;
        }

        public ConnectionParametersBuilder setMaxPoolSize(int n) {
            this.maxPoolSize = n;
            return this;
        }

        public ConnectionParametersBuilder setPoolTimeout(long l) {
            this.poolTimeout = l;
            return this;
        }

        public ConnectionParametersBuilder setReferral(String string) {
            this.referral = string;
            return this;
        }

        public ConnectionParametersBuilder setExtendedConf(Map<String, String> map) {
            this.extendedConf = map;
            return this;
        }

        public ConnectionParametersBuilder setSchemaEnabled(boolean bl) {
            this.schemaEnabled = bl;
            return this;
        }

        public ConnectionParametersBuilder setTlsEnabled(boolean bl) {
            this.f = bl;
            return this;
        }

        public ConnectionParametersBuilder setSslEnabled(boolean bl) {
            this.b = bl;
            return this;
        }

        public ConnectionParametersBuilder setTrustStorePath(String string) {
            this.trustStorePath = string;
            return this;
        }

        public ConnectionParametersBuilder setTrustStorePassword(String string) {
            this.trustStorePassword = string;
            return this;
        }

        public ConnectionParameters build() {
            return new ConnectionParameters(this);
        }
    }
}

