/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.connection;

import cz.integsoft.connectors.ldap.api.parameters.Type;
import cz.integsoft.connectors.ldap.internal.connection.ConnectionParameters;
import cz.integsoft.connectors.ldap.internal.connection.LDAPSchemaAware;
import cz.integsoft.connectors.ldap.internal.connection.jndi.LDAPJNDIConnection;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.metadata.MetaDataBuilder;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSet;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LDAPConnection
implements LDAPSchemaAware,
ConnectorConnection {
    private static final Logger g = LoggerFactory.getLogger(LDAPConnection.class);
    public static final boolean DEFAULT_SCHEMA_ENABLED = false;
    public static final boolean DEFAULT_TLS_ENABLED = false;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    protected static final Map<String, Class<?>> h = new HashMap();
    private boolean schemaEnabled = false;
    private boolean f = false;
    private boolean b = false;
    private String authentication;
    private MetaDataBuilder i;
    private final String j = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    public static final String NO_AUTHENTICATION = "none";
    public static final String SIMPLE_AUTHENTICATION = "simple";
    public static final String CONNECTION_TYPE_ATTR = "type";
    public static final String LDAP_URL_ATTR = "url";
    public static final String AUTHENTICATION_ATTR = "authentication";
    public static final String INITIAL_POOL_CONNECTIONS_ATTR = "initialPoolSize";
    public static final String MAX_POOL_CONNECTIONS_ATTR = "maxPoolSize";
    public static final String POOL_TIMEOUT_ATTR = "poolTimeout";
    public static final String REFERRAL_ATTR = "referral";
    public static final String SCHEMA_ENABLED = "schema-enabled";
    public static final String TLS_ENABLED = "tls-enabled";
    public static final String SSL_ENABLED = "ssl-enabled";
    public static final String TRUST_STORE_PATH = "truststore-path";
    public static final String TRUST_STORE_PASSWORD = "truststore-password";

    public static LDAPConnection getConnection(ConnectionParameters connectionParameters) {
        HashMap<String, String> hashMap = connectionParameters.getExtendedConf() != null ? new HashMap<String, String>(connectionParameters.getExtendedConf()) : new HashMap();
        hashMap.put(CONNECTION_TYPE_ATTR, connectionParameters.getType());
        hashMap.put(LDAP_URL_ATTR, connectionParameters.getUrl());
        hashMap.put(REFERRAL_ATTR, connectionParameters.getReferral());
        hashMap.put(AUTHENTICATION_ATTR, connectionParameters.getAuthentication());
        hashMap.put(INITIAL_POOL_CONNECTIONS_ATTR, String.valueOf(connectionParameters.getInitialPoolSize()));
        hashMap.put(MAX_POOL_CONNECTIONS_ATTR, String.valueOf(connectionParameters.getMaxPoolSize()));
        hashMap.put(POOL_TIMEOUT_ATTR, String.valueOf(connectionParameters.getPoolTimeout()));
        hashMap.put(SCHEMA_ENABLED, String.valueOf(connectionParameters.isSchemaEnabled()));
        hashMap.put(TLS_ENABLED, String.valueOf(connectionParameters.isTlsEnabled()));
        hashMap.put(SSL_ENABLED, String.valueOf(connectionParameters.isSslEnabled()));
        hashMap.put(TRUST_STORE_PATH, String.valueOf(connectionParameters.getTrustStorePath()));
        hashMap.put(TRUST_STORE_PASSWORD, String.valueOf(connectionParameters.getTrustStorePassword()));
        return LDAPConnection.getConnection(hashMap);
    }

    public static LDAPConnection getConnection(String string, String string2, String string3, int n, int n2, long l, String string4) {
        ConnectionParameters connectionParameters = new ConnectionParameters.ConnectionParametersBuilder(string, string2, string3).setInitialPoolSize(n).setMaxPoolSize(n2).setPoolTimeout(l).setReferral(string4).setExtendedConf(new HashMap<String, String>()).build();
        return LDAPConnection.getConnection(connectionParameters);
    }

    public static LDAPConnection getConnection(Map<String, String> map) {
        try {
            if (!map.containsKey(CONNECTION_TYPE_ATTR)) {
                throw new LDAPException("Could not instantiate connection as configuration is missing parameter [type]", LDAPErrorType.CONNECTIVITY);
            }
            if (h.get(map.get(CONNECTION_TYPE_ATTR)) == null) {
                throw new LDAPException("Could not instantiate connection as type [" + map.get(CONNECTION_TYPE_ATTR) + "] is not supported", LDAPErrorType.CONNECTIVITY);
            }
            LDAPConnection lDAPConnection = (LDAPConnection)h.get(map.get(CONNECTION_TYPE_ATTR)).newInstance();
            lDAPConnection.a(map);
            return lDAPConnection;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new LDAPException("Could not instantiate connection from configuration " + map, LDAPErrorType.CONNECTIVITY, reflectiveOperationException);
        }
        catch (Exception exception) {
            throw new LDAPException("Could not obtain connection from configuration " + map, LDAPErrorType.CONNECTIVITY, exception);
        }
    }

    @Override
    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public void setSchemaEnabled(boolean bl) {
        this.schemaEnabled = bl;
    }

    public boolean isTlsEnabled() {
        return this.f;
    }

    public void setTlsEnabled(boolean bl) {
        this.f = bl;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public MetaDataBuilder getMetaDataBuilder() {
        return this.i;
    }

    public void setMetaDataBuilder(MetaDataBuilder metaDataBuilder) {
        this.i = metaDataBuilder;
    }

    public String getConnectionId() {
        return "[" + this.j + "]:" + this;
    }

    public void disconnect() {
        String string = this.getConnectionId();
        g.debug("About to disconnect {}", (Object)string);
        try {
            this.close();
        }
        catch (LDAPException lDAPException) {
            g.error("Unable to close connection {}. Forcing close anyway. {}", (Object)string, (Object)lDAPException);
            throw lDAPException;
        }
    }

    public void validate() {
        if (!this.isValid()) {
            throw new LDAPException("Invalid session", LDAPErrorType.CONNECTIVITY);
        }
    }

    public boolean isSslEnabled() {
        return this.b;
    }

    public void setSslEnabled(boolean bl) {
        this.b = bl;
    }

    protected abstract void a(Map<String, String> var1);

    public abstract void bind(String var1, String var2);

    public abstract void rebind();

    public abstract LDAPResultSet search(String var1, String var2, Object[] var3, LDAPSearchControls var4);

    public abstract String getBindedUserDn();

    public abstract LDAPResultSet search(String var1, String var2, LDAPSearchControls var3);

    public abstract LDAPEntry lookup(String var1);

    public abstract void renameEntry(String var1, String var2);

    public abstract LDAPEntry lookup(String var1, String[] var2);

    public abstract void addEntry(LDAPEntry var1);

    public abstract void updateEntry(LDAPEntry var1);

    public abstract void deleteEntry(LDAPEntry var1);

    public abstract void deleteEntry(String var1);

    public abstract void addAttribute(String var1, LDAPEntryAttribute var2);

    public abstract void updateAttribute(String var1, LDAPEntryAttribute var2);

    public abstract void deleteAttribute(String var1, LDAPEntryAttribute var2);

    public abstract void close();

    public abstract boolean isClosed();

    public abstract void setAuthentication(String var1);

    public abstract void setTrustStore(String var1);

    public abstract void setTrustStorePassword(String var1);

    public abstract boolean isValid();

    static {
        h.put(Type.JNDI.toString(), LDAPJNDIConnection.class);
    }
}

