/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.connection.jndi;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cz.integsoft.connectors.ldap.api.parameters.Referral;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttributeTypeDefinition;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttributes;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import cz.integsoft.connectors.ldap.internal.util.ActiveDirectoryUUIDByteParser;
import cz.integsoft.connectors.ldap.internal.util.ExceptionUtils;
import cz.integsoft.connectors.ldap.internal.util.LDAPJNDIUtils;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSet;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSetFactory;
import cz.integsoft.connectors.ldap.internal.util.LDAPSSLSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPJNDIConnection
extends LDAPConnection {
    private static final Logger k = LoggerFactory.getLogger(LDAPJNDIConnection.class);
    public static final int DEFAULT_MAX_POOL_CONNECTIONS = 0;
    public static final int DEFAULT_INITIAL_POOL_CONNECTIONS = 0;
    public static final long DEFAULT_POOL_TIMEOUT = 0L;
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String DEFAULT_REFERRAL = Referral.IGNORE.toString();
    private static final boolean l = true;
    private static final String m = "initialContextFactory";
    private static final String n = "com.sun.jndi.ldap.connect.pool";
    private static final String o = "com.sun.jndi.ldap.connect.pool.maxsize";
    private static final String p = "com.sun.jndi.ldap.connect.pool.initsize";
    private static final String q = "com.sun.jndi.ldap.connect.pool.timeout";
    private static final String r = "com.sun.jndi.ldap.pool.authentication";
    private static final String s = "java.naming.ldap.attributes.binary";
    private static final String t = "SSL";
    private static final String u = "org.mule.module.ldap.trustStorePath";
    private static final String v = "org.mule.module.ldap.trustStorePassword";
    private static final String w = "java.naming.security.protocol";
    private static final String x = "java.naming.security.credentials";
    private static final String y = "java.naming.security.principal";
    private static final String z = "java.naming.factory.initial";
    private static final String A = "java.naming.security.authentication";
    private static final String B = "java.naming.referral";
    private static final String C = "java.naming.provider.url";
    private static final long D = 1000L;
    private String E = null;
    private int F = 0;
    private int G = 0;
    private long poolTimeout = 0L;
    private String authentication = "none";
    private String H = "com.sun.jndi.ldap.LdapCtxFactory";
    private String referral = DEFAULT_REFERRAL;
    private Map<String, String> I = null;
    private LoadingCache<String, LDAPEntryAttributeTypeDefinition> J = null;
    private LdapContext K = null;
    private StartTlsResponse L = null;
    private String trustStorePath;
    private String trustStorePassword;

    public LDAPJNDIConnection() {
    }

    public LDAPJNDIConnection(String string) {
        this(string, DEFAULT_INITIAL_CONTEXT_FACTORY);
    }

    public LDAPJNDIConnection(String string, String string2) {
        this(string, string2, "none");
    }

    public LDAPJNDIConnection(String string, String string2, String string3, int n, int n2, long l) {
        this(string, string2, string3, n, n2, l, false);
    }

    public LDAPJNDIConnection(String string, String string2, String string3) {
        this(string, string2, string3, 0, 0, 0L);
    }

    public LDAPJNDIConnection(String string, String string2, String string3, int n, int n2, long l, boolean bl) {
        this();
        this.setProviderUrl(string);
        this.setInitialContextFactory(string2);
        this.setAuthentication(string3);
        this.setMaxPoolConnections(n);
        this.setInitialPoolSizeConnections(n2);
        this.setPoolTimeout(l);
        this.setSchemaEnabled(bl);
        this.a();
    }

    private synchronized void a() {
        if (this.isSchemaEnabled() && this.J == null) {
            this.J = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, LDAPEntryAttributeTypeDefinition>(){

                public LDAPEntryAttributeTypeDefinition c(String string) {
                    return LDAPJNDIConnection.this.b(string);
                }

                public /* synthetic */ Object load(Object object) throws Exception {
                    return this.c((String)object);
                }
            });
        }
    }

    @Override
    protected void a(Map<String, String> map) {
        if (map != null) {
            this.b(map);
        }
    }

    private void b(Map<String, String> map) {
        k.debug("Initial config");
        this.I = new HashMap<String, String>(map);
        this.I.remove("type");
        this.setAuthentication(this.a(map, "authentication", "none"));
        this.I.remove("authentication");
        this.setInitialContextFactory(this.a(map, m, DEFAULT_INITIAL_CONTEXT_FACTORY));
        this.I.remove(m);
        this.setInitialPoolSizeConnections(this.a(map, "initialPoolSize", 0));
        this.I.remove("initialPoolSize");
        this.setMaxPoolConnections(this.a(map, "maxPoolSize", 0));
        this.I.remove("maxPoolSize");
        this.setPoolTimeout(this.a(map, "poolTimeout", 0L));
        this.I.remove("poolTimeout");
        this.setProviderUrl(this.a(map, "url", null));
        this.I.remove("url");
        this.setReferral(this.a(map, "referral", DEFAULT_REFERRAL));
        this.I.remove("referral");
        this.setSchemaEnabled("true".equals(this.a(map, "schema-enabled", String.valueOf(false))));
        this.a();
        this.I.remove("schema-enabled");
        this.setTlsEnabled("true".equals(this.a(map, "tls-enabled", String.valueOf(false))));
        this.I.remove("tls-enabled");
        this.setSslEnabled("true".equals(this.a(map, "ssl-enabled", String.valueOf(false))));
        this.I.remove("ssl-enabled");
        this.setTrustStore(this.a(map, u, this.a(map, "truststore-path", null)));
        this.I.remove(u);
        this.I.remove("truststore-path");
        this.setTrustStorePassword(this.a(map, v, this.a(map, "truststore-password", null)));
        this.I.remove(v);
        this.I.remove("truststore-password");
        k.debug("Initial config completed");
    }

    private String a(Map<String, String> map, String string, String string2) {
        String string3 = map.get(string);
        return StringUtils.isNotEmpty((String)string3) && !string3.equals("null") ? string3 : string2;
    }

    private int a(Map<String, String> map, String string, int n) {
        String string2 = map.get(string);
        return StringUtils.isNotEmpty((String)string2) ? Integer.parseInt(string2) : n;
    }

    private long a(Map<String, String> map, String string, long l) {
        String string2 = map.get(string);
        return StringUtils.isNotEmpty((String)string2) ? Long.parseLong(string2) : l;
    }

    private void a(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("tls: ").append(this.isTlsEnabled()).append(", ");
        stringBuilder.append("ssl: ").append(this.isSslEnabled()).append(", ");
        stringBuilder.append("url: ").append(this.getProviderUrl()).append(", ");
        stringBuilder.append("authentication: ").append(this.getAuthentication()).append(", ");
        if (!this.isNoAuthentication() && StringUtils.isNotEmpty((String)string)) {
            stringBuilder.append("authDn: ").append(string).append(", ");
        } else {
            stringBuilder.append("authDn: {anonymous}, ");
        }
        stringBuilder.append("initialContextFactory: ").append(this.getInitialContextFactory()).append(", ");
        stringBuilder.append("referral: ").append(this.getReferral()).append(", ");
        if (this.isConnectionPoolEnabled()) {
            stringBuilder.append("initialPoolSize: ").append(this.getInitialPoolSizeConnections()).append(", ");
            stringBuilder.append("maxPoolSize: ").append(this.getMaxPoolConnections()).append(", ");
            stringBuilder.append("poolTimeout: ").append(this.getPoolTimeout());
        } else {
            stringBuilder.append("pool: disabled");
        }
        if (this.I != null && !this.I.isEmpty()) {
            stringBuilder.append(", extended: ").append(this.I);
        }
        stringBuilder.append("}");
        if (k.isDebugEnabled()) {
            k.debug("{}", (Object)stringBuilder);
        }
    }

    public boolean isNoAuthentication() {
        return "none".equalsIgnoreCase(this.getAuthentication());
    }

    @Override
    public boolean isClosed() {
        return this.K == null;
    }

    @Override
    public void close() {
        k.debug("Closing connection");
        if (!this.isClosed()) {
            String string = this.toString();
            try {
                this.g().close();
                k.info("Connection {} closed.", (Object)string);
            }
            catch (NamingException namingException) {
                k.error("Close connection {} failed. {}", (Object)string, (Object)namingException);
            }
            finally {
                this.b((LdapContext)null);
                this.L = null;
                k.info("TLS has been set to null after connection is closed.");
            }
        } else {
            k.warn("Connection already closed.");
        }
    }

    private Map<String, String> a(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getReferral() != null) {
            hashMap.put(B, this.getReferral());
        }
        hashMap.put(A, this.getAuthentication());
        if (!this.isNoAuthentication()) {
            hashMap.put(y, string);
            hashMap.put(x, string2);
        }
        hashMap.put(z, this.getInitialContextFactory());
        hashMap.put(C, this.getProviderUrl());
        hashMap.put(s, "objectGUID objectSid");
        if (this.isConnectionPoolEnabled()) {
            hashMap.put(n, "true");
            hashMap.put(r, this.getAuthentication());
            if (this.getMaxPoolConnections() > 0) {
                hashMap.put(o, String.valueOf(this.getMaxPoolConnections()));
            }
            if (this.getInitialPoolSizeConnections() > 0) {
                hashMap.put(p, String.valueOf(this.getInitialPoolSizeConnections()));
            }
            if (this.getPoolTimeout() > 0L) {
                hashMap.put(q, String.valueOf(this.getPoolTimeout()));
            }
        } else {
            hashMap.put(n, "false");
        }
        if (this.I != null && !this.I.isEmpty()) {
            hashMap.putAll(this.I);
        }
        if (this.isSslEnabled()) {
            hashMap.put(w, "ssl");
        }
        k.debug("Created environment without authentication credentials: {}", hashMap);
        return hashMap;
    }

    @Override
    public void rebind() {
        k.debug("Rebinding");
        if (this.isClosed()) {
            throw new LDAPException("Cannot rebind a close connection. You must first bind.", LDAPErrorType.CONNECTIVITY);
        }
        String string = this.getBindedUserDn();
        String string2 = this.f();
        this.bind(string, string2);
    }

    @Override
    public void bind(String string, String string2) {
        LdapContext ldapContext = null;
        k.debug("Binding - DN: {}", (Object)string);
        try {
            k.debug("Binding - Is connection closed: {}", (Object)this.isClosed());
            if (!this.isClosed()) {
                String string3 = (String)this.g().getEnvironment().get(C);
                String string4 = (String)this.g().getEnvironment().get(A);
                String string5 = this.getBindedUserDn();
                k.info("Already binded to {} with {} authentication as {}. Closing connection first.", new Object[]{string3, string4, string5 != null ? string5 : "anonymous"});
                this.close();
                k.info("Re-binding to {} with {} authentication as {}", new Object[]{this.getProviderUrl(), this.getAuthentication(), string});
            }
            this.a(string);
            if (!"none".equals(this.getAuthentication()) && string == null) {
                throw new LDAPException("Invalid Credentials: dn cannot be null.", LDAPErrorType.INVALID_ATTRIBUTE);
            }
            string = LDAPJNDIUtils.escapeMetaCharacters(string);
            ldapContext = this.b(string, string2);
            this.b(ldapContext);
            k.info("Binded to {} with {} authentication as {}", new Object[]{this.getProviderUrl(), this.getAuthentication(), string});
        }
        catch (NamingException namingException) {
            this.a((DirContext)ldapContext);
            throw this.a(namingException, "Bind failed.");
        }
        catch (Exception exception) {
            this.a((DirContext)ldapContext);
            throw new LDAPException(LDAPErrorType.UNKNOWN, exception);
        }
        k.debug("Binding - Complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapContext b(String string, String string2) throws NamingException {
        Object object;
        InitialLdapContext initialLdapContext = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(s, "objectGUID objectSid");
        Map<String, String> map = this.a(string, string2);
        Set<String> set = map.keySet();
        for (String object22 : set) {
            if (object22 == null || (object = map.get(object22)) == null) continue;
            hashtable.put(object22, (String)object);
        }
        Thread thread = Thread.currentThread();
        object = thread.getContextClassLoader();
        thread.setContextClassLoader(LDAPJNDIConnection.class.getClassLoader());
        try {
            k.debug("Binding - TLS: {} | SSL: {}", (Object)this.isTlsEnabled(), (Object)this.isSslEnabled());
            if (this.isTlsEnabled() || this.isSslEnabled()) {
                Map<String, String> map2 = this.c(hashtable);
                if (this.isSslEnabled()) {
                    this.c();
                }
                initialLdapContext = new InitialLdapContext(hashtable, null);
                if (this.isTlsEnabled()) {
                    this.a(initialLdapContext);
                }
                this.a(map2, initialLdapContext);
            } else {
                initialLdapContext = new InitialLdapContext(hashtable, null);
            }
        }
        finally {
            thread.setContextClassLoader((ClassLoader)object);
        }
        return initialLdapContext;
    }

    private void b() {
        k.debug("TrustStore validation - Path: {} | Is Password set; {}", (Object)this.trustStorePath, (Object)(!Strings.isNullOrEmpty((String)this.trustStorePassword) ? 1 : 0));
        if (!Strings.isNullOrEmpty((String)this.trustStorePath) || !Strings.isNullOrEmpty((String)this.trustStorePassword)) {
            Optional<File> optional = this.d();
            if (!optional.isPresent()) {
                k.debug("TrustStore validation - Error: Invalid TrustStore path {}", (Object)this.trustStorePath);
                throw new LDAPException(LDAPErrorType.CONNECTIVITY, new Exception("Wrong TrustStore path: " + this.trustStorePath));
            }
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream fileInputStream = new FileInputStream(optional.get());){
                    keyStore.load(fileInputStream, this.trustStorePassword.toCharArray());
                }
            }
            catch (Exception exception) {
                k.debug("TrustStore validation | Error: TrustStore file exists in {} but the password is incorrect", (Object)this.trustStorePath);
                throw new LDAPException(LDAPErrorType.CONNECTIVITY, new Exception("Failed to validate password for " + this.trustStorePath + ": " + exception.getMessage(), exception));
            }
        }
    }

    private void c() {
        k.debug("SSL initialization");
        this.b();
        try {
            SSLContext sSLContext = SSLContext.getInstance(t);
            sSLContext.init(new KeyManager[0], LDAPJNDIUtils.getCustomTrustStoreWithDefaultCerts(this.d(), this.trustStorePassword), new SecureRandom());
            SSLContext.setDefault(sSLContext);
        }
        catch (Exception exception) {
            throw new LDAPException(LDAPErrorType.CONNECTIVITY, new Exception("Failed to set custom TrustStore", exception));
        }
    }

    private void a(Map<String, String> map, LdapContext ldapContext) throws NamingException {
        k.debug("Applying authentication configuration");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            k.debug("Applying authentication configuration. Key: {} | Value: {}", (Object)entry.getKey(), (Object)entry.getValue());
            ldapContext.addToEnvironment(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> c(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        k.debug("Removing authentication configuration from environment");
        for (String string : Arrays.asList(A, x, y, w)) {
            String string2 = map.remove(string);
            if (string2 != null) {
                hashMap.put(string, string2);
            }
            k.debug("Removing authentication configuration from environment. Key {} | Value {}", (Object)string, (Object)string2);
        }
        return hashMap;
    }

    private void a(LdapContext ldapContext) {
        try {
            k.debug("Enabling TLS");
            this.L = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
            Optional<File> optional = this.d();
            if (optional.isPresent()) {
                this.b();
                LDAPSSLSocketFactory lDAPSSLSocketFactory = new LDAPSSLSocketFactory(optional.get(), this.trustStorePassword);
                SSLSession sSLSession = this.L.negotiate(lDAPSSLSocketFactory);
                k.info("TLS enabled successfully using protocol {}  with clientkeystore.jks", (Object)sSLSession.getProtocol());
            } else {
                SSLSession sSLSession = this.L.negotiate();
                k.info("TLS enabled successfully using protocol {} ", (Object)sSLSession.getProtocol());
            }
        }
        catch (NamingException namingException) {
            this.e();
            throw this.a(namingException, "TLS initialization failed.");
        }
        catch (IOException iOException) {
            this.e();
            throw this.a(iOException, "TLS negotiation failed.");
        }
    }

    private Optional<File> d() {
        k.debug("Getting trustStore file {}", (Object)this.trustStorePath);
        if (Objects.isNull(this.trustStorePath)) {
            k.debug("Getting trustStore file - Undefined path, returning empty file");
            return Optional.empty();
        }
        File file = new File(this.trustStorePath);
        if (!file.exists()) {
            URL uRL = this.getClass().getClassLoader().getResource(this.trustStorePath);
            k.debug("Failed to get file, retrying on absolute path.");
            if (Objects.isNull(uRL)) {
                k.error("Failed to get file on absolute path");
                return Optional.empty();
            }
            file = new File(uRL.getPath());
            k.debug("Getting trustStore file - Found file in {}", (Object)uRL.getPath());
        }
        return Optional.of(file);
    }

    private void e() {
        k.debug("Silently closing TLS");
        try {
            if (this.L != null) {
                this.L.close();
            }
        }
        catch (Exception exception) {
            k.info("Closing TLS connection failed.", (Throwable)exception);
        }
        finally {
            this.L = null;
        }
    }

    private String f() {
        try {
            return (String)this.g().getEnvironment().get(x);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Cannot get binded user password.");
        }
    }

    @Override
    public String getBindedUserDn() {
        if (!this.isClosed()) {
            try {
                return (String)this.g().getEnvironment().get(y);
            }
            catch (NamingException namingException) {
                throw this.a(namingException, "Cannot get binded user DN.");
            }
        }
        return null;
    }

    @Override
    public LDAPResultSet search(String string, String string2, LDAPSearchControls lDAPSearchControls) {
        return this.a(string, string2, null, lDAPSearchControls, this.buildLDAPContext(lDAPSearchControls));
    }

    @Override
    public LDAPResultSet search(String string, String string2, Object[] objectArray, LDAPSearchControls lDAPSearchControls) {
        return this.a(string, string2, objectArray, lDAPSearchControls, this.buildLDAPContext(lDAPSearchControls));
    }

    public LdapContext buildLDAPContext(LDAPSearchControls lDAPSearchControls) {
        try {
            return lDAPSearchControls.isPagingEnabled() ? this.b(this.getBindedUserDn(), this.f()) : this.g();
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Unable to construct a valid LDAP Context.");
        }
    }

    private LDAPResultSet a(String string, String string2, Object[] objectArray, LDAPSearchControls lDAPSearchControls, LdapContext ldapContext) {
        try {
            k.debug("Searching. BaseDN: {} | Filter: {}", (Object)string, (Object)string2);
            if (string2.toLowerCase().contains("objectguid=")) {
                string2 = ActiveDirectoryUUIDByteParser.replaceFilterGUID(string2);
            }
            if (lDAPSearchControls.isPagingEnabled()) {
                ldapContext.setRequestControls(LDAPJNDIUtils.buildRequestControls(lDAPSearchControls, null));
            }
            NamingEnumeration<SearchResult> namingEnumeration = objectArray != null && objectArray.length > 0 ? ldapContext.search(string, string2, objectArray, LDAPJNDIUtils.buildSearchControls(lDAPSearchControls)) : ldapContext.search(string, string2, LDAPJNDIUtils.buildSearchControls(lDAPSearchControls));
            return LDAPResultSetFactory.create(string, string2, objectArray, ldapContext, lDAPSearchControls, namingEnumeration, this.isSchemaEnabled() ? this : null);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Search failed.");
        }
    }

    @Override
    public LDAPEntry lookup(String string) {
        try {
            k.debug("LookUp. DN: {}", (Object)string);
            return LDAPJNDIUtils.buildEntry(string, this.g().getAttributes(string), this.isSchemaEnabled() ? this : null);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Lookup of entry " + string + " failed.");
        }
    }

    @Override
    public LDAPEntry lookup(@NotNull String string, String[] stringArray) {
        try {
            k.debug("LookUp. DN: {}", (Object)string);
            return LDAPJNDIUtils.buildEntry(string, this.g().getAttributes(string, stringArray), this.isSchemaEnabled() ? this : null);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Lookup of entry " + string + " failed.");
        }
    }

    @Override
    public void addEntry(@NotNull LDAPEntry lDAPEntry) {
        try {
            this.g().bind(lDAPEntry.getDn(), null, this.a(lDAPEntry));
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Add entry " + lDAPEntry.getDn() + " failed.");
        }
    }

    private LDAPException a(NamingException namingException, String string) {
        k.warn(string, (Throwable)namingException);
        return ExceptionUtils.buildLdapException(namingException);
    }

    private LDAPException a(Exception exception, String string) {
        k.warn(string, (Throwable)exception);
        return new LDAPException(exception.getMessage(), LDAPErrorType.UNKNOWN, exception);
    }

    @Override
    public void updateEntry(@NotNull LDAPEntry lDAPEntry) {
        try {
            ModificationItem[] modificationItemArray = new ModificationItem[lDAPEntry.getAttributeCount()];
            Iterator<LDAPEntryAttribute> iterator = lDAPEntry.attributes();
            for (int i = 0; iterator.hasNext() && i < modificationItemArray.length; ++i) {
                modificationItemArray[i] = new ModificationItem(2, this.a(iterator.next()));
            }
            this.g().modifyAttributes(LDAPJNDIUtils.escapeMetaCharacters(lDAPEntry.getDn()), modificationItemArray);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Update entry " + lDAPEntry.getDn() + " failed.");
        }
    }

    @Override
    public void deleteEntry(LDAPEntry lDAPEntry) {
        this.deleteEntry(lDAPEntry.getDn());
    }

    @Override
    public void deleteEntry(String string) {
        try {
            k.debug("About to delete entry {} ", (Object)string);
            this.g().unbind(LDAPJNDIUtils.escapeMetaCharacters(string));
            k.info("Deleted entry {} ", (Object)string);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Delete entry failed.");
        }
    }

    @Override
    public void renameEntry(String string, String string2) {
        try {
            k.debug("About to rename entry {} to {}", (Object)string, (Object)string2);
            this.g().rename(LDAPJNDIUtils.escapeMetaCharacters(string), LDAPJNDIUtils.escapeMetaCharacters(string2));
            k.info("Renamed entry {} to {} ", (Object)string, (Object)string2);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Rename entry " + string + " to " + string2 + " failed.");
        }
    }

    @Override
    public void addAttribute(@NotNull String string, @NotNull LDAPEntryAttribute lDAPEntryAttribute) {
        try {
            ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(1, this.a(lDAPEntryAttribute))};
            this.g().modifyAttributes(LDAPJNDIUtils.escapeMetaCharacters(string), modificationItemArray);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Add attribute " + lDAPEntryAttribute.getName() + " to entry " + string + " failed.");
        }
    }

    @Override
    public void updateAttribute(@NotNull String string, @NotNull LDAPEntryAttribute lDAPEntryAttribute) {
        try {
            ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(2, this.a(lDAPEntryAttribute))};
            this.g().modifyAttributes(LDAPJNDIUtils.escapeMetaCharacters(string), modificationItemArray);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Update attribute " + lDAPEntryAttribute.getName() + " from entry " + string + " failed.");
        }
    }

    @Override
    public void deleteAttribute(@NotNull String string, @NotNull LDAPEntryAttribute lDAPEntryAttribute) {
        try {
            ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(3, this.a(lDAPEntryAttribute))};
            this.g().modifyAttributes(LDAPJNDIUtils.escapeMetaCharacters(string), modificationItemArray);
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Delete attribute " + lDAPEntryAttribute.getName() + " from entry " + string + " failed.");
        }
    }

    private void a(DirContext dirContext) {
        if (dirContext != null) {
            try {
                dirContext.close();
            }
            catch (NamingException namingException) {
                k.warn("Cannot close directory context", (Throwable)namingException);
            }
        }
    }

    @Override
    public synchronized LDAPEntryAttributeTypeDefinition getAttributeTypeDefinition(@NotNull String string) {
        if (this.J != null) {
            try {
                return (LDAPEntryAttributeTypeDefinition)this.J.get((Object)string);
            }
            catch (ExecutionException executionException) {
                k.error("Could not retrieve attribute type definition for attribute " + string + " from cache. Trying to retrieve directly.", (Throwable)executionException);
                return this.b(string);
            }
        }
        k.info("Schema cache disabled. Retrieving attribute type definition directly.");
        return this.b(string);
    }

    protected LDAPEntryAttributeTypeDefinition b(@NotNull String string) {
        DirContext dirContext = null;
        DirContext dirContext2 = null;
        try {
            dirContext = this.g().getSchema("");
            k.debug("About to retrieve attribute definition for attribute {}", (Object)string);
            dirContext2 = (DirContext)dirContext.lookup("AttributeDefinition/" + string);
            LDAPEntryAttributeTypeDefinition lDAPEntryAttributeTypeDefinition = LDAPJNDIUtils.buildAttributeTypeDefinition(dirContext2.getAttributes(""));
            this.a(dirContext2);
            this.a(dirContext);
            return lDAPEntryAttributeTypeDefinition;
        }
        catch (NamingException namingException) {
            try {
                throw this.a(namingException, "Get attribute type definition for attribute " + string + " failed.");
            }
            catch (Throwable throwable) {
                this.a(dirContext2);
                this.a(dirContext);
                throw throwable;
            }
        }
    }

    @Override
    public List<String> getAllObjectClasses() {
        DirContext dirContext = null;
        try {
            Serializable serializable;
            dirContext = this.g().getSchema("");
            k.debug("About to retrieve all object classes");
            NamingEnumeration<Binding> namingEnumeration = dirContext.listBindings("ClassDefinition");
            ArrayList<String> arrayList = new ArrayList<String>(200);
            while (namingEnumeration.hasMore()) {
                serializable = namingEnumeration.next();
                arrayList.add(((NameClassPair)serializable).getName());
            }
            serializable = arrayList;
            return serializable;
        }
        catch (NamingException namingException) {
            throw this.a(namingException, "Get all object classes failed.");
        }
        finally {
            this.a(dirContext);
        }
    }

    @Override
    public LDAPEntryObjectClassDefinition getObjectClassDefinition(String string) {
        DirContext dirContext = null;
        DirContext dirContext2 = null;
        try {
            dirContext = this.g().getSchema("");
            k.debug("About to retrieve class definition for objectClass {}", (Object)string);
            dirContext2 = (DirContext)dirContext.lookup("ClassDefinition/" + string);
            LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition = LDAPJNDIUtils.buildObjectClassDefinition(dirContext2.getAttributes(""));
            this.a(dirContext2);
            this.a(dirContext);
            return lDAPEntryObjectClassDefinition;
        }
        catch (NamingException namingException) {
            try {
                throw this.a(namingException, "Get class definition for objectClass " + string + " failed.");
            }
            catch (Throwable throwable) {
                this.a(dirContext2);
                this.a(dirContext);
                throw throwable;
            }
        }
    }

    @Override
    public String getAuthentication() {
        return this.authentication;
    }

    @Override
    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public int getInitialPoolSizeConnections() {
        return this.G;
    }

    public void setInitialPoolSizeConnections(int n) {
        this.G = n;
    }

    public int getMaxPoolConnections() {
        return this.F;
    }

    public void setMaxPoolConnections(int n) {
        this.F = n;
    }

    public long getPoolTimeout() {
        return this.poolTimeout;
    }

    public void setPoolTimeout(long l) {
        this.poolTimeout = l;
    }

    public String getProviderUrl() {
        return this.E;
    }

    public void setProviderUrl(String string) {
        this.E = string;
    }

    public boolean isConnectionPoolEnabled() {
        return this.getInitialPoolSizeConnections() > 0;
    }

    public String getInitialContextFactory() {
        return this.H;
    }

    public void setInitialContextFactory(String string) {
        this.H = string;
    }

    private LdapContext g() {
        if (this.K == null) {
            k.debug("Tried to get a closed connection");
            throw new LDAPException("Connection is closed. Call bind method first.", LDAPErrorType.CONNECTIVITY);
        }
        return this.K;
    }

    private void b(LdapContext ldapContext) {
        this.K = ldapContext;
    }

    private Attributes a(LDAPEntryAttributes lDAPEntryAttributes) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        Iterator<LDAPEntryAttribute> iterator = lDAPEntryAttributes.attributes();
        while (iterator.hasNext()) {
            basicAttributes.put(this.a(iterator.next()));
        }
        return basicAttributes;
    }

    private Attributes a(@NotNull LDAPEntry lDAPEntry) {
        return this.a(lDAPEntry.getAttributes());
    }

    private BasicAttribute a(@NotNull LDAPEntryAttribute lDAPEntryAttribute) {
        if (lDAPEntryAttribute.isMultiValued()) {
            BasicAttribute basicAttribute = new BasicAttribute(lDAPEntryAttribute.getName());
            for (Object object : lDAPEntryAttribute.getValues()) {
                basicAttribute.add(object);
            }
            return basicAttribute;
        }
        return new BasicAttribute(lDAPEntryAttribute.getName(), lDAPEntryAttribute.getValue());
    }

    public String getReferral() {
        return this.referral;
    }

    public void setReferral(String string) {
        this.referral = string;
    }

    public String toString() {
        try {
            String string = this.getBindedUserDn();
            return (string != null ? string : "anonymous") + "@" + this.getProviderUrl();
        }
        catch (Exception exception) {
            return "{unknown}@" + this.getProviderUrl();
        }
    }

    @Override
    public void setTrustStore(String string) {
        this.trustStorePath = string;
    }

    @Override
    public void setTrustStorePassword(String string) {
        this.trustStorePassword = string;
    }

    @Override
    public boolean isValid() {
        return this.K != null;
    }
}

