/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.connection.parameters;

import java.util.Objects;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class CustomTrustStoreParameterGroup {
    @Summary(value="Custom path to the TrustStore that contains the certificates needed for a secure authentication. The supported formats are JKS and PKCS12.")
    @Parameter
    @Path(type=PathModel.Type.FILE)
    @Placement(order=1, tab="Security")
    @Optional
    @DisplayName(value="TrustStore Path")
    private String trustStorePath;
    @Summary(value="Custom password for the custom TrustStore file")
    @Parameter
    @Placement(order=2, tab="Security")
    @Optional
    @Password
    @DisplayName(value="TrustStore Password")
    private String trustStorePassword;

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public int hashCode() {
        return Objects.hash(this.trustStorePassword, this.trustStorePath);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CustomTrustStoreParameterGroup customTrustStoreParameterGroup = (CustomTrustStoreParameterGroup)object;
        return Objects.equals(this.trustStorePassword, customTrustStoreParameterGroup.trustStorePassword) && Objects.equals(this.trustStorePath, customTrustStoreParameterGroup.trustStorePath);
    }
}

