/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.connection.provider;

import cz.integsoft.connectors.ldap.api.parameters.BasicAuthAdvancedPoolingParameterGroup;
import cz.integsoft.connectors.ldap.api.parameters.BasicAuthParameterGroup;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.parameters.bundle.BasicParamsBundle;
import cz.integsoft.connectors.ldap.internal.service.connection.ConnectionService;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="basic")
@DisplayName(value="Basic Configuration")
public class BasicConnectionProvider
extends ConnectorConnectionProvider<LDAPConnection>
implements ConnectionProvider<LDAPConnection> {
    private static final Logger N = LoggerFactory.getLogger(BasicConnectionProvider.class);
    public static final String FIPS140_2 = "fips140-2";
    public static final String MULE_SECURITY_MODEL_PROPERTY = "mule.security.model";
    public static final String FIPS140_2_NO_COMPLIANT_MESSAGE = "This connection type is not secure and cannot be used with the fips140-2 security model.";
    public static final String BASIC = "basic";
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private BasicAuthParameterGroup O;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private BasicAuthAdvancedPoolingParameterGroup P;
    private final ConnectionService Q = new ConnectionService("basic");

    public LDAPConnection connect() throws ConnectionException {
        if (FIPS140_2.equals(System.getProperty(MULE_SECURITY_MODEL_PROPERTY))) {
            throw new LDAPException(FIPS140_2_NO_COMPLIANT_MESSAGE, LDAPErrorType.SECURITY);
        }
        BasicParamsBundle basicParamsBundle = new BasicParamsBundle();
        basicParamsBundle.setBasicAuthParams(this.O);
        basicParamsBundle.setBasicAuthAdvancedPoolingParams(this.P);
        return this.Q.connect(basicParamsBundle);
    }

    public void disconnect(LDAPConnection lDAPConnection) {
        try {
            lDAPConnection.disconnect();
        }
        catch (LDAPException lDAPException) {
            N.debug("Error while executing disconnect method : {}, {} ", (Object)lDAPException.getMessage(), (Object)lDAPException);
        }
    }

    public ConnectionValidationResult validate(LDAPConnection lDAPConnection) {
        try {
            lDAPConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception exception) {
            return ConnectionValidationResult.failure((String)exception.getMessage(), (Exception)exception);
        }
    }

    public void setBasicAuthParams(BasicAuthParameterGroup basicAuthParameterGroup) {
        this.O = basicAuthParameterGroup;
    }

    public void setBasicAuthAdvancedPoolingParams(BasicAuthAdvancedPoolingParameterGroup basicAuthAdvancedPoolingParameterGroup) {
        this.P = basicAuthAdvancedPoolingParameterGroup;
    }
}

