/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.connection.provider;

import cz.integsoft.connectors.ldap.api.parameters.BasicAuthAdvancedParameterGroup;
import cz.integsoft.connectors.ldap.api.parameters.BasicAuthParameterGroup;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.connection.parameters.CustomTrustStoreParameterGroup;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.parameters.bundle.SecuredParamsBundle;
import cz.integsoft.connectors.ldap.internal.service.connection.ConnectionService;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecureConnectionProvider
extends ConnectorConnectionProvider<LDAPConnection>
implements ConnectionProvider<LDAPConnection> {
    private static final Logger R = LoggerFactory.getLogger(SecureConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private BasicAuthParameterGroup O;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private BasicAuthAdvancedParameterGroup S;
    @ParameterGroup(name="Custom Trust Store")
    @Placement(order=3)
    private CustomTrustStoreParameterGroup T;
    private final ConnectionService U;

    protected SecureConnectionProvider(ConnectionService connectionService) {
        this.U = connectionService;
    }

    public LDAPConnection connect() throws ConnectionException {
        SecuredParamsBundle securedParamsBundle = new SecuredParamsBundle();
        securedParamsBundle.setBasicAuthParams(this.O);
        securedParamsBundle.setBasicAuthAdvancedParams(this.S);
        securedParamsBundle.setCustomTrustStoreParameterGroup(this.T);
        return this.U.connect(securedParamsBundle);
    }

    public void disconnect(LDAPConnection lDAPConnection) {
        try {
            lDAPConnection.disconnect();
        }
        catch (LDAPException lDAPException) {
            R.debug("Error while executing disconnect method : {}, {} ", (Object)lDAPException.getMessage(), (Object)lDAPException);
        }
    }

    public ConnectionValidationResult validate(LDAPConnection lDAPConnection) {
        try {
            lDAPConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception exception) {
            return ConnectionValidationResult.failure((String)exception.getMessage(), (Exception)exception);
        }
    }

    public void setBasicAuthParams(BasicAuthParameterGroup basicAuthParameterGroup) {
        this.O = basicAuthParameterGroup;
    }

    public void setBasicAuthAdvancedParams(BasicAuthAdvancedParameterGroup basicAuthAdvancedParameterGroup) {
        this.S = basicAuthAdvancedParameterGroup;
    }

    public void setCustomTrustStoreParameterGroup(CustomTrustStoreParameterGroup customTrustStoreParameterGroup) {
        this.T = customTrustStoreParameterGroup;
    }
}

