/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.metadata;

import cz.integsoft.connectors.ldap.internal.config.LDAPConfiguration;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.metadata.MetaDataBuilder;
import cz.integsoft.connectors.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.api.util.StringUtils;

public class LDAPEntryObjectClassMetadataResolver
implements InputTypeResolver<String>,
OutputTypeResolver<String>,
TypeKeysResolver {
    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        HashSet<MetadataKey> hashSet = new HashSet<MetadataKey>();
        try {
            Optional optional = metadataContext.getConnection();
            LDAPConnection lDAPConnection = (LDAPConnection)optional.get();
            List<String> list = lDAPConnection.getAllObjectClasses();
            for (String string : list) {
                hashSet.add(MetadataKeyBuilder.newKey((String)string).withDisplayName(string).build());
            }
        }
        catch (Exception exception) {
            throw new MetadataResolvingException(exception.getMessage(), FailureCode.UNKNOWN, (Throwable)exception);
        }
        return hashSet;
    }

    public MetadataType getOutputType(MetadataContext metadataContext, String string) throws MetadataResolvingException, ConnectionException {
        try {
            Optional optional = metadataContext.getConnection();
            LDAPConnection lDAPConnection = (LDAPConnection)optional.get();
            LDAPConfiguration lDAPConfiguration = (LDAPConfiguration)metadataContext.getConfig().get();
            BaseTypeBuilder baseTypeBuilder = new BaseTypeBuilder(JavaTypeLoader.JAVA);
            if (StringUtils.isBlank((String)string)) {
                return baseTypeBuilder.objectType().build();
            }
            LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition = lDAPConnection.getObjectClassDefinition(string);
            ObjectTypeBuilder objectTypeBuilder = baseTypeBuilder.objectType().id(string).label(string);
            MetaDataBuilder metaDataBuilder = lDAPConnection.getMetaDataBuilder();
            metaDataBuilder.transverseObjectClassHierarchy(lDAPEntryObjectClassDefinition, objectTypeBuilder, lDAPConfiguration.isShowAttributesAsObjects());
            return objectTypeBuilder.build();
        }
        catch (Exception exception) {
            throw new MetadataResolvingException(exception.getMessage(), FailureCode.UNKNOWN, (Throwable)exception);
        }
    }

    public MetadataType getInputMetadata(MetadataContext metadataContext, String string) throws MetadataResolvingException, ConnectionException {
        return this.getOutputType(metadataContext, string);
    }

    public String getCategoryName() {
        return this.getClass().getSimpleName();
    }

    public String getResolverName() {
        return this.getClass().getSimpleName();
    }
}

