/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.metadata;

import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttributeTypeDefinition;
import cz.integsoft.connectors.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import cz.integsoft.connectors.ldap.internal.model.datasense.SyntaxObjectIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public class MetaDataBuilder {
    private static final String Z = "top";
    private LDAPConnection aa;

    public MetaDataBuilder(LDAPConnection lDAPConnection) {
        this.aa = lDAPConnection;
    }

    public List<String> getObjectClassHierarchyFor(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition = this.getConnection().getObjectClassDefinition(string);
        arrayList.add(lDAPEntryObjectClassDefinition.getName());
        this.transverseObjectClassHierarchy(lDAPEntryObjectClassDefinition.getSupName(), arrayList);
        return arrayList;
    }

    public void transverseObjectClassHierarchy(@NotNull String string, @NotNull List<String> list) {
        list.add(string);
        if (!Z.equalsIgnoreCase(string)) {
            LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition = this.getConnection().getObjectClassDefinition(string);
            this.transverseObjectClassHierarchy(lDAPEntryObjectClassDefinition.getSupName(), list);
        }
    }

    public void transverseObjectClassHierarchy(@NotNull LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition, ObjectTypeBuilder objectTypeBuilder, boolean bl) {
        this.addAttributesMetaData(lDAPEntryObjectClassDefinition.getMust(), objectTypeBuilder, bl);
        this.addAttributesMetaData(lDAPEntryObjectClassDefinition.getMay(), objectTypeBuilder, bl);
        if (lDAPEntryObjectClassDefinition.getSupName() != null && !Z.equalsIgnoreCase(lDAPEntryObjectClassDefinition.getSupName())) {
            LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition2 = this.getConnection().getObjectClassDefinition(lDAPEntryObjectClassDefinition.getSupName());
            this.transverseObjectClassHierarchy(lDAPEntryObjectClassDefinition2, objectTypeBuilder, bl);
        }
    }

    public void addAttributesMetaData(List<String> list, ObjectTypeBuilder objectTypeBuilder, boolean bl) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            if (bl) {
                objectTypeBuilder.addField().key(string).value(this.createAttributeObjectMetadataType(string));
                continue;
            }
            LDAPEntryAttributeTypeDefinition lDAPEntryAttributeTypeDefinition = this.getConnection().getAttributeTypeDefinition(string);
            if (lDAPEntryAttributeTypeDefinition.isSingleValue()) {
                if (this.a(lDAPEntryAttributeTypeDefinition)) {
                    objectTypeBuilder.addField().key(string).value().stringType();
                    continue;
                }
                objectTypeBuilder.addField().key(string).value().anyType();
                continue;
            }
            objectTypeBuilder.addField().key(string).value().anyType();
        }
    }

    public MetadataType createAttributeObjectMetadataType(String string) {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectTypeBuilder.id(string);
        objectTypeBuilder.addField().key("value").value().anyType();
        objectTypeBuilder.addField().key("typeDefinition").value(this.createAttributeTypeDefinitionMetadatatype());
        objectTypeBuilder.addField().key("name").value().stringType();
        objectTypeBuilder.addField().key("multiValued").value().booleanType();
        objectTypeBuilder.addField().key("values").value().arrayType().of().anyType();
        return objectTypeBuilder.build();
    }

    public MetadataType createAttributeTypeDefinitionMetadatatype() {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectTypeBuilder.id("typedef");
        objectTypeBuilder.addField().key("noUserModification").value().booleanType();
        objectTypeBuilder.addField().key("ordering").value().anyType();
        objectTypeBuilder.addField().key("usage").value().anyType();
        objectTypeBuilder.addField().key("obsolete").value().booleanType();
        objectTypeBuilder.addField().key("singleValue").value().booleanType();
        objectTypeBuilder.addField().key("description").value().stringType();
        objectTypeBuilder.addField().key("substring").value().anyType();
        objectTypeBuilder.addField().key("numericOid").value().stringType();
        objectTypeBuilder.addField().key("name").value().stringType();
        objectTypeBuilder.addField().key("syntax").value().stringType();
        objectTypeBuilder.addField().key("collective").value().booleanType();
        objectTypeBuilder.addField().key("supName").value().anyType();
        objectTypeBuilder.addField().key("equality").value().stringType();
        return objectTypeBuilder.build();
    }

    private boolean a(LDAPEntryAttributeTypeDefinition lDAPEntryAttributeTypeDefinition) {
        try {
            return SyntaxObjectIdentifier.isHumanReadable(lDAPEntryAttributeTypeDefinition.getSyntax());
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }

    @NotNull
    public LDAPConnection getConnection() {
        return this.aa;
    }

    public void setConnection(@NotNull LDAPConnection lDAPConnection) {
        this.aa = lDAPConnection;
    }
}

