/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.model;

import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttributes;
import cz.integsoft.connectors.ldap.internal.model.LDAPMultiValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPSingleValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.util.LDAPUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LDAPEntry
implements Serializable,
Map<String, Object> {
    public static final String MAP_DN_KEY = "dn";
    private static final long ad = -1L;
    private String ae = null;
    private LDAPEntryAttributes af = new LDAPEntryAttributes();

    public LDAPEntry() {
        this((String)null);
    }

    public LDAPEntry(String string) {
        this.setDn(string);
    }

    public LDAPEntry(String string, Map<String, ?> map) {
        if (string == null) {
            throw new IllegalArgumentException("Entry DN cannot be null.");
        }
        HashMap hashMap = new HashMap(map);
        hashMap.put(MAP_DN_KEY, string);
        try {
            this.d(hashMap);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalArgumentException((Throwable)((Object)lDAPException));
        }
    }

    public LDAPEntry(Map<String, Object> map) {
        this.d(new HashMap<String, Object>(map));
    }

    public String getDn() {
        return this.ae;
    }

    public void setDn(String string) {
        this.ae = string;
    }

    public void addAttribute(LDAPEntryAttribute lDAPEntryAttribute) {
        this.af.addAttribute(lDAPEntryAttribute);
    }

    public void addAttribute(String string, Object object) {
        if (object instanceof Collection) {
            this.addAttribute(new LDAPMultiValueEntryAttribute(string, (Collection)object));
        } else if (object instanceof Object[]) {
            this.addAttribute(new LDAPMultiValueEntryAttribute(string, (Object[])object));
        } else {
            this.addAttribute(new LDAPSingleValueEntryAttribute(string, object));
        }
    }

    public LDAPEntryAttribute getAttribute(String string) {
        if (string != null) {
            return this.getAttributes().getAttribute(string);
        }
        return null;
    }

    public void resetAttributes() {
        this.af.resetAttributes();
    }

    public int getAttributeCount() {
        return this.af.getCount();
    }

    public Iterator<LDAPEntryAttribute> attributes() {
        return this.af.attributes();
    }

    public String toLDIFString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dn: " + this.getDn() + LDAPUtils.NEW_LINE);
        Iterator<LDAPEntryAttribute> iterator = this.attributes();
        while (iterator.hasNext()) {
            LDAPEntryAttribute lDAPEntryAttribute = iterator.next();
            stringBuilder.append(lDAPEntryAttribute.toLDIFString());
        }
        stringBuilder.append(LDAPUtils.NEW_LINE);
        return stringBuilder.toString();
    }

    private void d(Map<String, ?> map) {
        Object obj = map.remove(MAP_DN_KEY);
        if (obj == null || !(obj instanceof String)) {
            throw new LDAPException("The map representing the LDAP entry should contain the key 'dn' with the string value of the DN (Distinguished Name) of the entry.", LDAPErrorType.UNKNOWN);
        }
        this.setDn((String)obj);
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            Object obj2 = map.get(string2);
            this.addAttribute(string2, obj2);
        }
    }

    public String toString() {
        return this.toLDIFString();
    }

    public LDAPEntryAttributes getAttributes() {
        return this.af;
    }

    public void setAttributes(LDAPEntryAttributes lDAPEntryAttributes) {
        this.af = lDAPEntryAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LDAPEntry)) {
            return false;
        }
        LDAPEntry lDAPEntry = (LDAPEntry)object;
        return this.getDn() != null && this.getDn().equals(lDAPEntry.getDn());
    }

    @Override
    public int hashCode() {
        return this.getDn() != null ? this.getDn().hashCode() : super.hashCode();
    }

    @Override
    public void clear() {
        this.getAttributes().resetAttributes();
        this.setDn(null);
    }

    private String a(Object object) {
        if (object == null || object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("Key should be a string. " + object.getClass() + " is not supported");
    }

    @Override
    public boolean containsKey(Object object) {
        if (MAP_DN_KEY.equals(object)) {
            return this.getDn() != null;
        }
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, LDAPEntryAttribute> entry : this.af.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        if (this.getDn() != null) {
            hashMap.put(MAP_DN_KEY, this.getDn());
        }
        return hashMap.entrySet();
    }

    @Override
    public Object get(Object object) {
        String string = this.a(object);
        if (MAP_DN_KEY.equals(string)) {
            return this.getDn();
        }
        LDAPEntryAttribute lDAPEntryAttribute = this.getAttribute(string);
        if (lDAPEntryAttribute != null) {
            return lDAPEntryAttribute.isMultiValued() ? lDAPEntryAttribute.getValues() : lDAPEntryAttribute.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getDn() == null && this.getAttributeCount() <= 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>(this.af.getCount() + 1);
        if (this.getDn() != null) {
            hashSet.add(MAP_DN_KEY);
        }
        Iterator<LDAPEntryAttribute> iterator = this.attributes();
        while (iterator.hasNext()) {
            LDAPEntryAttribute lDAPEntryAttribute = iterator.next();
            hashSet.add(lDAPEntryAttribute.getName());
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object put(String string, Object object) {
        if (MAP_DN_KEY.equals(string)) {
            if (object != null && !(object instanceof String)) throw new IllegalArgumentException("DN should be a string. " + string.getClass() + " is not supported");
            this.setDn((String)object);
            return object;
        } else {
            this.addAttribute(string, object);
        }
        return object;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        map.forEach(this::put);
    }

    @Override
    public Object remove(Object object) {
        if (MAP_DN_KEY.equals(object)) {
            String string = this.getDn();
            this.setDn(null);
            return string;
        }
        return this.af.removeAttribute(this.a(object));
    }

    @Override
    public int size() {
        return this.getDn() != null ? 1 : this.getAttributeCount();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.af.getCount() + 1);
        if (this.getDn() != null) {
            arrayList.add(this.getDn());
        }
        Iterator<LDAPEntryAttribute> iterator = this.attributes();
        while (iterator.hasNext()) {
            LDAPEntryAttribute lDAPEntryAttribute = iterator.next();
            if (!lDAPEntryAttribute.isMultiValued()) {
                arrayList.add(lDAPEntryAttribute.getValue());
                continue;
            }
            arrayList.add(lDAPEntryAttribute.getValues());
        }
        return arrayList;
    }

    public static LDAPEntry getInstanceFromMap(Map<String, Object> map) {
        return map instanceof LDAPEntry ? (LDAPEntry)map : new LDAPEntry(map);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.getDn() != null) {
            hashMap.put(MAP_DN_KEY, this.getDn());
        }
        LDAPEntryAttribute lDAPEntryAttribute = null;
        Iterator<LDAPEntryAttribute> iterator = this.attributes();
        while (iterator.hasNext()) {
            lDAPEntryAttribute = iterator.next();
            if (!lDAPEntryAttribute.isMultiValued()) {
                hashMap.put(lDAPEntryAttribute.getName(), lDAPEntryAttribute.getValue());
                continue;
            }
            hashMap.put(lDAPEntryAttribute.getName(), lDAPEntryAttribute.getValues());
        }
        return hashMap;
    }

    public static List<Map<String, Object>> getListOfMaps(List<LDAPEntry> list) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (list != null) {
            for (LDAPEntry lDAPEntry : list) {
                arrayList.add(lDAPEntry.toMap());
            }
        }
        return arrayList;
    }
}

