/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.operation;

import cz.integsoft.connectors.ldap.internal.config.LDAPConfiguration;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.error.provider.LDAPErrorTypeProvider;
import cz.integsoft.connectors.ldap.internal.metadata.LDAPEntryObjectClassMetadataResolver;
import cz.integsoft.connectors.ldap.internal.service.EntryService;
import cz.integsoft.connectors.ldap.internal.service.EntryServiceImpl;
import java.util.List;
import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Throws(value={LDAPErrorTypeProvider.class})
public class EntryOperations
extends ConnectorOperations<LDAPConfiguration, LDAPConnection, EntryService> {
    public EntryOperations() {
        super(EntryServiceImpl::new);
    }

    @DisplayName(value="Add entry")
    public void add(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @Content @TypeResolver(value=LDAPEntryObjectClassMetadataResolver.class) Map<String, Object> map, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional String string) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::add).withParam(map).withParam((Object)string);
    }

    @DisplayName(value="Modify entry")
    public void modify(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @Content @TypeResolver(value=LDAPEntryObjectClassMetadataResolver.class) Map<String, Object> map, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional String string) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::modify).withParam(map).withParam((Object)string);
    }

    @DisplayName(value="Delete entry")
    public void delete(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::delete).withParam((Object)string);
    }

    @DisplayName(value="Rename entry")
    public void rename(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @Placement(order=1) @DisplayName(value="Current DN") String string, @Placement(order=2) @DisplayName(value="New DN") String string2) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::rename).withParam((Object)string).withParam((Object)string2);
    }

    public void addSingleValueAttribute(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string, String string2, String string3, @Optional(defaultValue="false") boolean bl) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::addSingleValueAttribute).withParam((Object)string).withParam((Object)string2).withParam((Object)string3).withParam((Object)bl);
    }

    public void addMultiValueAttribute(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string, String string2, @Content List<Object> list, @Optional(defaultValue="false") boolean bl) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::addMultiValueAttribute).withParam((Object)string).withParam((Object)string2).withParam(list).withParam((Object)bl);
    }

    public void modifySingleValueAttribute(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string, String string2, String string3, @Optional(defaultValue="false") boolean bl) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::modifySingleValueAttribute).withParam((Object)string).withParam((Object)string2).withParam((Object)string3).withParam((Object)bl);
    }

    public void modifyMultiValueAttribute(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string, String string2, @Content List<Object> list, @Optional(defaultValue="false") boolean bl) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::modifyMultiValueAttribute).withParam((Object)string).withParam((Object)string2).withParam(list).withParam((Object)bl);
    }

    public void deleteSingleValueAttribute(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string, String string2, @Optional String string3, @Optional(defaultValue="false") boolean bl) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::deleteSingleValueAttribute).withParam((Object)string).withParam((Object)string2).withParam((Object)string3).withParam((Object)bl);
    }

    public void deleteMultiValueAttribute(@Config LDAPConfiguration lDAPConfiguration, @Connection LDAPConnection lDAPConnection, @DisplayName(value="DN") String string, String string2, @Content List<Object> list, @Optional(defaultValue="false") boolean bl) {
        this.a(lDAPConfiguration, lDAPConnection).execute(EntryService::deleteMultiValueAttribute).withParam((Object)string).withParam((Object)string2).withParam(list).withParam((Object)bl);
    }

    protected ExecutionBuilder<EntryService> a(LDAPConfiguration lDAPConfiguration, LDAPConnection lDAPConnection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)lDAPConfiguration, (ConnectorConnection)lDAPConnection).withExceptionHandler(Exception.class, exception -> {
            throw new LDAPException(LDAPErrorType.UNKNOWN, exception);
        })).withExceptionHandler(LDAPException.class, lDAPException -> {
            throw lDAPException;
        })).withExceptionHandler(ConnectionException.class, connectionException -> {
            throw new LDAPException(connectionException.getMessage(), LDAPErrorType.CONNECTIVITY, connectionException);
        });
    }

    protected /* synthetic */ ExecutionBuilder newExecutionBuilder(ConnectorConfig connectorConfig, ConnectorConnection connectorConnection) {
        return this.a((LDAPConfiguration)connectorConfig, (LDAPConnection)connectorConnection);
    }
}

