/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.operation.paging;

import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPEntryPagingProvider
implements PagingProvider<LDAPConnection, Map<String, Object>> {
    private static final Logger aT = LoggerFactory.getLogger((String)LDAPEntryPagingProvider.class.getName());
    private LDAPResultSet aU;
    private final int aV;
    private final String aW;
    private final String aX;
    private final LDAPSearchControls aY;
    private boolean aZ = false;
    private boolean a = false;

    public LDAPEntryPagingProvider(String string, String string2, LDAPSearchControls lDAPSearchControls, int n, boolean bl) {
        this.aW = string;
        this.aX = string2;
        this.aY = lDAPSearchControls;
        this.aV = n;
        this.a = bl;
    }

    public void close(LDAPConnection lDAPConnection) {
        if (this.aU != null) {
            this.aU.close();
            this.aU = null;
            lDAPConnection.disconnect();
        }
    }

    public Optional<Integer> getTotalResults(LDAPConnection lDAPConnection) {
        if (this.aU != null) {
            return Optional.of(this.aU.isLastElement() ? (int)this.aY.getMaxResults() : this.aU.getResultSize());
        }
        aT.info("Result set was null, bad connection or no results.");
        return Optional.of(0);
    }

    public List<Map<String, Object>> getPage(LDAPConnection lDAPConnection) {
        if (!this.aZ) {
            this.aU = lDAPConnection.search(this.aW, this.aX, this.aY);
            this.aZ = true;
        }
        if (!this.aU.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(this.aV);
        for (int i = 0; this.aU.hasNext() && i < this.aV; ++i) {
            if (this.a) {
                arrayList.add(this.aU.next());
                continue;
            }
            arrayList.add(this.aU.next().toMap());
        }
        return arrayList;
    }
}

