/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.service;

import cz.integsoft.connectors.ldap.internal.config.LDAPConfiguration;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.service.ConnectionOperationsService;
import cz.integsoft.connectors.ldap.internal.service.LDIFConversionServiceImpl;
import cz.integsoft.connectors.ldap.internal.util.ActiveDirectoryUUIDByteParser;
import java.util.Map;
import java.util.Optional;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionOperationsServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements ConnectionOperationsService {
    private static final Logger ba = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);
    private static final String bb = "objectGUID";
    private static final String bc = "objectSid";

    public ConnectionOperationsServiceImpl(LDAPConfiguration lDAPConfiguration, LDAPConnection lDAPConnection) {
        super((ConnectorConfig)lDAPConfiguration, (ConnectorConnection)lDAPConnection);
    }

    @Override
    public Map<String, Object> bind(String string, String string2, String string3) {
        try {
            if (string == null) {
                ((LDAPConnection)this.getConnection()).rebind();
            } else {
                ((LDAPConnection)this.getConnection()).setAuthentication(string3);
                ((LDAPConnection)this.getConnection()).bind(string, string2);
            }
            String string4 = ((LDAPConnection)this.getConnection()).getBindedUserDn();
            ba.info("Bind was successful for user: {} ", (Object)(string4 != null ? string4 : "Anonymous"));
            if (string4 != null) {
                ba.debug("About to retrieve authenticated user entry for: {}", (Object)string4);
                LDAPEntry lDAPEntry = ((LDAPConnection)this.getConnection()).lookup(string4);
                Optional.ofNullable(lDAPEntry.getAttribute(bc)).ifPresent(lDAPEntryAttribute -> lDAPEntry.addAttribute(bc, ActiveDirectoryUUIDByteParser.parseSID((byte[])lDAPEntryAttribute.getValue())));
                Optional.ofNullable(lDAPEntry.getAttribute(bb)).ifPresent(lDAPEntryAttribute -> lDAPEntry.addAttribute(bb, ActiveDirectoryUUIDByteParser.parseGUID((byte[])lDAPEntryAttribute.getValue())));
                ba.debug("Retrieved entry: {}", (Object)lDAPEntry);
                return lDAPEntry.toMap();
            }
            ba.debug("Anonymous user returns no entry (null)");
        }
        catch (Exception exception) {
            ba.warn("Error while executing bind operation : {}", (Object)exception.getMessage());
            throw exception;
        }
        return null;
    }

    @Override
    public void unbind() {
        try {
            ((LDAPConnection)this.getConnection()).disconnect();
        }
        catch (Exception exception) {
            ba.warn("Error while executing unbind operation : {}", (Object)exception.getMessage());
            throw exception;
        }
    }
}

