/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.service;

import cz.integsoft.connectors.ldap.internal.config.LDAPConfiguration;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.model.LDAPSingleValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPSortKey;
import cz.integsoft.connectors.ldap.internal.operation.SearchOperationParameters;
import cz.integsoft.connectors.ldap.internal.operation.paging.LDAPEntryPagingProvider;
import cz.integsoft.connectors.ldap.internal.service.EntrySearchService;
import cz.integsoft.connectors.ldap.internal.service.LDIFConversionServiceImpl;
import cz.integsoft.connectors.ldap.internal.util.ActiveDirectoryUUIDByteParser;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntrySearchServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements EntrySearchService {
    private static final Logger bd = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);
    public static final String OBJECT_GUID = "objectGUID";
    public static final String OBJECT_SID = "objectSid";

    public EntrySearchServiceImpl(LDAPConfiguration lDAPConfiguration, LDAPConnection lDAPConnection) {
        super((ConnectorConfig)lDAPConfiguration, (ConnectorConnection)lDAPConnection);
    }

    @Override
    public Map<String, Object> lookup(String string, List<String> list, String string2, boolean bl) {
        LDAPEntry lDAPEntry;
        try {
            bd.debug("About to retrieve LDAP entry: {}", (Object)string);
            lDAPEntry = list != null && !list.isEmpty() ? ((LDAPConnection)this.getConnection()).lookup(string, list.toArray(new String[list.size()])) : ((LDAPConnection)this.getConnection()).lookup(string);
            bd.debug("Retrieved entry: {}", (Object)lDAPEntry);
            if (list != null && !list.isEmpty() && !list.contains("dn")) {
                lDAPEntry.setDn(null);
            }
        }
        catch (Exception exception) {
            bd.warn("Error while executing lookup operation : {}", (Object)exception.getMessage());
            throw exception;
        }
        if (bl) {
            return lDAPEntry;
        }
        return lDAPEntry.toMap();
    }

    @Override
    public boolean exists(String string) {
        boolean bl = false;
        try {
            this.lookup(string, null, null, false);
            bl = true;
        }
        catch (LDAPException lDAPException) {
            bd.warn("DN not found.", (Throwable)((Object)lDAPException));
            bd.warn("Error while executing exists operation : {}", (Object)lDAPException.getMessage());
        }
        return bl;
    }

    @Override
    public List<Map<String, Object>> search(SearchOperationParameters searchOperationParameters) {
        try (LDAPResultSet lDAPResultSet = null;){
            bd.debug("About to search LDAP entries matching {} under: {} ", (Object)searchOperationParameters.getFilter(), (Object)searchOperationParameters.getBaseDn());
            LDAPSearchControls lDAPSearchControls = new LDAPSearchControls();
            if (searchOperationParameters.getAttributes() != null && !searchOperationParameters.getAttributes().isEmpty()) {
                lDAPSearchControls.setAttributesToReturn((String[])searchOperationParameters.getAttributes().toArray((Object[])new String[searchOperationParameters.getAttributes().size()]));
            }
            lDAPSearchControls.setMaxResults(searchOperationParameters.getMaxResults());
            lDAPSearchControls.setTimeout(searchOperationParameters.getTimeout());
            lDAPSearchControls.setScope(searchOperationParameters.getScope());
            lDAPSearchControls.setReturnObject(searchOperationParameters.isReturnObject());
            lDAPSearchControls.setPageSize(searchOperationParameters.getPageSize());
            lDAPResultSet = ((LDAPConnection)this.getConnection()).search(searchOperationParameters.getBaseDn(), searchOperationParameters.getFilter(), lDAPSearchControls);
            if (searchOperationParameters.isShowAttributesAsObjects()) {
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(lDAPResultSet.getAllEntries());
                this.a(arrayList);
                bd.debug("Retrieved {} entries", (Object)arrayList.size());
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            List<LDAPEntry> list = lDAPResultSet.getAllEntries();
            list.forEach(lDAPEntry -> {
                Optional.ofNullable(lDAPEntry.getAttribute(OBJECT_SID)).ifPresent(lDAPEntryAttribute -> lDAPEntry.addAttribute(OBJECT_SID, ActiveDirectoryUUIDByteParser.parseSID((byte[])lDAPEntryAttribute.getValue())));
                Optional.ofNullable(lDAPEntry.getAttribute(OBJECT_GUID)).ifPresent(lDAPEntryAttribute -> lDAPEntry.addAttribute(OBJECT_GUID, ActiveDirectoryUUIDByteParser.parseGUID((byte[])lDAPEntryAttribute.getValue())));
            });
            bd.debug("Retrieved {} entries", (Object)list.size());
            List<Map<String, Object>> list2 = LDAPEntry.getListOfMaps(list);
            return list2;
        }
    }

    private void a(List<Map<String, Object>> list) {
        list.forEach(map -> {
            map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(OBJECT_GUID)).forEach(this.a((Map<String, Object>)map, OBJECT_GUID));
            map.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(OBJECT_SID)).forEach(this.a((Map<String, Object>)map, OBJECT_SID));
        });
    }

    private Consumer<Map.Entry<String, Object>> a(Map<String, Object> map, String string) {
        if (string.equals(OBJECT_GUID)) {
            return entry -> map.replace(string, new LDAPSingleValueEntryAttribute(string, ActiveDirectoryUUIDByteParser.parseGUID((byte[])((LDAPSingleValueEntryAttribute)entry.getValue()).getValue())));
        }
        return entry -> map.replace(string, new LDAPSingleValueEntryAttribute(string, ActiveDirectoryUUIDByteParser.parseSID((byte[])((LDAPSingleValueEntryAttribute)entry.getValue()).getValue())));
    }

    @Override
    public PagingProvider<LDAPConnection, Map<String, Object>> pagedResultSearch(SearchOperationParameters searchOperationParameters, String string, boolean bl, int n) {
        try {
            bd.debug("About to search LDAP entries matching {} under: {}. Returning results in pages of {} entries.", new Object[]{searchOperationParameters.getFilter(), searchOperationParameters.getBaseDn(), searchOperationParameters.getPageSize()});
            LDAPSearchControls lDAPSearchControls = new LDAPSearchControls();
            if (searchOperationParameters.getAttributes() != null && !searchOperationParameters.getAttributes().isEmpty()) {
                lDAPSearchControls.setAttributesToReturn((String[])searchOperationParameters.getAttributes().toArray((Object[])new String[searchOperationParameters.getAttributes().size()]));
            }
            lDAPSearchControls.setMaxResults(searchOperationParameters.getMaxResults());
            lDAPSearchControls.setTimeout(searchOperationParameters.getTimeout());
            lDAPSearchControls.setScope(searchOperationParameters.getScope());
            lDAPSearchControls.setReturnObject(searchOperationParameters.isReturnObject());
            lDAPSearchControls.setPageSize(searchOperationParameters.getPageSize());
            if (StringUtils.isNotBlank((String)string)) {
                lDAPSearchControls.getSortKeys().add(new LDAPSortKey(string, bl, null));
            }
            return new LDAPEntryPagingProvider(searchOperationParameters.getBaseDn(), searchOperationParameters.getFilter(), lDAPSearchControls, n, searchOperationParameters.isShowAttributesAsObjects());
        }
        catch (Exception exception) {
            bd.warn("Error while executing pagedResultSearch operation : {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    @Override
    public Map<String, Object> searchOne(SearchOperationParameters searchOperationParameters) {
        List<Map<String, Object>> list;
        try {
            bd.debug("Searching entries under {} with filter {}", (Object)searchOperationParameters.getBaseDn(), (Object)searchOperationParameters.getFilter());
            list = this.search(searchOperationParameters);
            if (list != null && list.size() > 1) {
                bd.warn("Search returned more than one result. Total results matching filter [{}]: {} ", (Object)searchOperationParameters.getFilter(), (Object)list.size());
            }
        }
        catch (Exception exception) {
            bd.warn("Error while executing searchOne operation : {}", (Object)exception.getMessage());
            throw exception;
        }
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }
}

