/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.service;

import cz.integsoft.connectors.ldap.internal.config.LDAPConfiguration;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPMultiValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPSingleValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.service.EntryService;
import cz.integsoft.connectors.ldap.internal.service.LDIFConversionServiceImpl;
import cz.integsoft.connectors.ldap.internal.util.LDAPJNDIUtils;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements EntryService {
    private static final String be = "objectClass";
    private static final Logger bf = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);

    public EntryServiceImpl(LDAPConfiguration lDAPConfiguration, LDAPConnection lDAPConnection) {
        super((ConnectorConfig)lDAPConfiguration, (ConnectorConnection)lDAPConnection);
    }

    @Override
    public void add(Map<String, Object> map, String string) {
        try {
            LDAPEntry lDAPEntry = LDAPEntry.getInstanceFromMap(map);
            String string2 = lDAPEntry.getDn();
            if (string2 != null) {
                lDAPEntry.setDn(LDAPJNDIUtils.escapeMetaCharacters(string2));
            }
            this.a(lDAPEntry, string);
            bf.debug("About to add entry {}: {}", (Object)lDAPEntry.getDn(), map);
            ((LDAPConnection)this.getConnection()).addEntry(lDAPEntry);
            bf.info("Added entry {}", (Object)lDAPEntry.getDn());
        }
        catch (Exception exception) {
            bf.warn("Error while executing add operation : {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    private void a(@NotNull LDAPEntry lDAPEntry, String string) {
        LDAPEntryAttribute lDAPEntryAttribute = lDAPEntry.getAttribute(be);
        if (lDAPEntryAttribute != null) {
            List<Object> list = lDAPEntryAttribute.getValues();
            if (!list.contains(string)) {
                bf.warn("Entry {} does not contain the specified structural objectClass {}. Defined objectClasses are: {}", new Object[]{lDAPEntry.getDn(), string, list});
            }
        } else {
            bf.debug("Entry {} does not contain objectClass attribute. Setting objectClasses based on {} hierarchy", (Object)lDAPEntry.getDn(), (Object)string);
            try {
                List<String> list = ((LDAPConnection)this.getConnection()).getMetaDataBuilder().getObjectClassHierarchyFor(string);
                bf.debug("Setting objectClass values {} to entry {}", list, (Object)lDAPEntry.getDn());
                lDAPEntry.addAttribute(be, list);
            }
            catch (LDAPException lDAPException) {
                bf.warn("Could not retrieve objectClass hierarchy for " + string, (Throwable)((Object)lDAPException));
            }
        }
    }

    @Override
    public void modify(Map<String, Object> map, String string) {
        try {
            LDAPEntry lDAPEntry = LDAPEntry.getInstanceFromMap(map);
            bf.debug("About to modify entry {}: {}", (Object)lDAPEntry.getDn(), map);
            ((LDAPConnection)this.getConnection()).updateEntry(lDAPEntry);
            bf.info("Modified entry {}", (Object)lDAPEntry.getDn());
        }
        catch (Exception exception) {
            bf.warn("Error while executing modify operation : {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    @Override
    public void delete(String string) {
        try {
            bf.debug("About to delete entry {}", (Object)string);
            ((LDAPConnection)this.getConnection()).deleteEntry(string);
            bf.info("Deleted entry {}", (Object)string);
        }
        catch (Exception exception) {
            bf.warn("Error while executing delete operation : {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    @Override
    public void rename(String string, String string2) {
        try {
            bf.debug("About to rename entry {} to {}", (Object)string, (Object)string2);
            ((LDAPConnection)this.getConnection()).renameEntry(string, string2);
            bf.info("Renamed entry {} to {}", (Object)string, (Object)string2);
        }
        catch (Exception exception) {
            bf.warn("Error while executing rename operation : {}", (Object)exception.getMessage());
            throw exception;
        }
    }

    @Override
    public void addSingleValueAttribute(String string, String string2, String string3, boolean bl) {
        try {
            bf.debug("About to add attribute {} with value {} to entry {}", new Object[]{string2, string3, string});
            ((LDAPConnection)this.getConnection()).addAttribute(string, new LDAPSingleValueEntryAttribute(string2, string3));
            bf.info("Added attribute {} with value {} to entry {}", new Object[]{string2, string3, string});
        }
        catch (Exception exception) {
            this.a(exception, "addSingleValueAttribute", "addition", bl);
        }
    }

    @Override
    public void addMultiValueAttribute(String string, String string2, List<Object> list, boolean bl) {
        try {
            bf.debug("About to add attribute {} with values {} to entry {}", new Object[]{string2, list, string});
            ((LDAPConnection)this.getConnection()).addAttribute(string, new LDAPMultiValueEntryAttribute(string2, list));
            bf.info("Added attribute {} with values {} to entry {}", new Object[]{string2, list, string});
        }
        catch (Exception exception) {
            this.a(exception, "addMultiValueAttribute", "addition", bl);
        }
    }

    @Override
    public void modifySingleValueAttribute(String string, String string2, String string3, boolean bl) {
        try {
            bf.debug("About to update attribute {} with value {} to entry {}", new Object[]{string2, string3, string});
            ((LDAPConnection)this.getConnection()).updateAttribute(string, new LDAPSingleValueEntryAttribute(string2, string3));
            bf.info("Updated attribute {} with value {} to entry {}", new Object[]{string2, string3, string});
        }
        catch (Exception exception) {
            this.a(exception, "modifySingleValueAttribute", "modification", bl);
        }
    }

    @Override
    public void modifyMultiValueAttribute(String string, String string2, List<Object> list, boolean bl) {
        try {
            bf.debug("About to modify attribute {} with values {} to entry {}", new Object[]{string2, list, string});
            ((LDAPConnection)this.getConnection()).updateAttribute(string, new LDAPMultiValueEntryAttribute(string2, list));
            bf.info("Modified attribute {} with values {} to entry {}", new Object[]{string2, list, string});
        }
        catch (Exception exception) {
            this.a(exception, "modifyMultiValueAttribute", "modification", bl);
        }
    }

    @Override
    public void deleteSingleValueAttribute(String string, String string2, String string3, boolean bl) {
        try {
            bf.debug("About to delete value {} from attribute {} on entry {}", new Object[]{string3, string2, string});
            ((LDAPConnection)this.getConnection()).deleteAttribute(string, new LDAPSingleValueEntryAttribute(string2, string3));
            if (string3 != null && string3.length() > 0) {
                bf.info("Deleted value {} from attribute {} from entry {}", new Object[]{string3, string2, string});
            } else {
                bf.info("Deleted attribute {} from entry {}", (Object)string2, (Object)string);
            }
        }
        catch (Exception exception) {
            this.a(exception, "deleteSingleValueAttribute", "deletion", bl);
        }
    }

    @Override
    public void deleteMultiValueAttribute(String string, String string2, List<Object> list, boolean bl) {
        try {
            bf.debug("About to delete values {} from attribute {} on entry {}", new Object[]{list, string2, string});
            ((LDAPConnection)this.getConnection()).deleteAttribute(string, new LDAPMultiValueEntryAttribute(string2, list));
            bf.info("Deleted values {} from attribute {} on entry {}", new Object[]{list, string2, string});
        }
        catch (Exception exception) {
            this.a(exception, "deleteMultiValueAttribute", "deletion", bl);
        }
    }

    private void a(Exception exception, String string, String string2, boolean bl) {
        if (exception instanceof LDAPException) {
            LDAPException lDAPException = (LDAPException)((Object)exception);
            if (!bl) {
                bf.warn("Error while executing {} operation : {}", (Object)string, (Object)lDAPException.getMessage());
                throw lDAPException;
            }
            if (lDAPException.getType().equals((Object)LDAPErrorType.INVALID_ATTRIBUTE)) {
                bf.info("Ignoring attribute {} : {}", (Object)string2, (Object)lDAPException.getMessage());
            }
        } else {
            bf.warn("Error while executing {} operation : {}", (Object)string, (Object)exception.getMessage());
            throw new RuntimeException(exception);
        }
    }
}

