/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.service.connection;

import cz.integsoft.connectors.ldap.api.parameters.BasicAuthAdvancedParameterGroup;
import cz.integsoft.connectors.ldap.api.parameters.BasicAuthAdvancedPoolingParameterGroup;
import cz.integsoft.connectors.ldap.internal.connection.ConnectionParameters;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.connection.parameters.CustomTrustStoreParameterGroup;
import cz.integsoft.connectors.ldap.internal.metadata.MetaDataBuilder;
import cz.integsoft.connectors.ldap.internal.parameters.bundle.BasicParamsBundle;
import cz.integsoft.connectors.ldap.internal.parameters.bundle.LdapConnectionParameters;
import cz.integsoft.connectors.ldap.internal.parameters.bundle.SecuredParamsBundle;
import cz.integsoft.connectors.ldap.internal.util.ExceptionUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService {
    private static final Logger bh = LoggerFactory.getLogger(ConnectionService.class);
    private static final String bi = "basic";
    private static final String bj = "ssl";
    private static final String bk = "tls";
    private final String bl;
    private static final int bm = 0;
    private static final int bn = 0;

    public ConnectionService(String string) {
        this.bl = string;
    }

    public LDAPConnection connect(LdapConnectionParameters ldapConnectionParameters) throws ConnectionException {
        LDAPConnection lDAPConnection;
        String string = ldapConnectionParameters.getBasicAuthParams().getAuthentication();
        string = string == null ? "simple" : string;
        try {
            ConnectionParameters.ConnectionParametersBuilder connectionParametersBuilder;
            if (this.bl.equals(bi)) {
                BasicAuthAdvancedPoolingParameterGroup basicAuthAdvancedPoolingParameterGroup = ((BasicParamsBundle)ldapConnectionParameters).getBasicAuthAdvancedPoolingParams();
                connectionParametersBuilder = new ConnectionParameters.ConnectionParametersBuilder(basicAuthAdvancedPoolingParameterGroup.getType().toString(), ldapConnectionParameters.getBasicAuthParams().getUrl(), string).setInitialPoolSize(basicAuthAdvancedPoolingParameterGroup.getInitialPoolSize()).setMaxPoolSize(basicAuthAdvancedPoolingParameterGroup.getMaxPoolSize()).setPoolTimeout(basicAuthAdvancedPoolingParameterGroup.getPoolTimeout()).setReferral(basicAuthAdvancedPoolingParameterGroup.getReferral().toString()).setExtendedConf(basicAuthAdvancedPoolingParameterGroup.getExtendedConfiguration()).setSchemaEnabled(basicAuthAdvancedPoolingParameterGroup.isSchemaEnabled());
            } else {
                BasicAuthAdvancedParameterGroup basicAuthAdvancedParameterGroup = ((SecuredParamsBundle)ldapConnectionParameters).getBasicAuthAdvancedParams();
                CustomTrustStoreParameterGroup customTrustStoreParameterGroup = ((SecuredParamsBundle)ldapConnectionParameters).getCustomTrustStoreParameterGroup();
                connectionParametersBuilder = new ConnectionParameters.ConnectionParametersBuilder(basicAuthAdvancedParameterGroup.getType().toString(), ldapConnectionParameters.getBasicAuthParams().getUrl(), string).setInitialPoolSize(0).setMaxPoolSize(0).setPoolTimeout(0L).setReferral(basicAuthAdvancedParameterGroup.getReferral().toString()).setExtendedConf(basicAuthAdvancedParameterGroup.getExtendedConfiguration()).setSchemaEnabled(basicAuthAdvancedParameterGroup.isSchemaEnabled()).setTrustStorePath(customTrustStoreParameterGroup.getTrustStorePath()).setTrustStorePassword(customTrustStoreParameterGroup.getTrustStorePassword());
                if (this.bl.equals(bj)) {
                    connectionParametersBuilder.setSslEnabled(true);
                } else if (this.bl.equals(bk)) {
                    connectionParametersBuilder.setTlsEnabled(true);
                }
            }
            lDAPConnection = LDAPConnection.getConnection(connectionParametersBuilder.build());
            if ("none".equals(string)) {
                lDAPConnection.bind(null, null);
            } else {
                lDAPConnection.bind(ldapConnectionParameters.getBasicAuthParams().getAuthDn(), ldapConnectionParameters.getBasicAuthParams().getAuthPassword());
            }
            lDAPConnection.setAuthentication(string);
            lDAPConnection.setMetaDataBuilder(new MetaDataBuilder(lDAPConnection));
        }
        catch (Exception exception) {
            bh.error("Exception occurred in establishing connection.", (Throwable)exception);
            throw ExceptionUtils.toConnectionException(exception);
        }
        return lDAPConnection;
    }
}

