/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.sources;

import cz.integsoft.connectors.ldap.api.SearchScope;
import cz.integsoft.connectors.ldap.internal.config.LDAPConfiguration;
import cz.integsoft.connectors.ldap.internal.connection.LDAPConnection;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.metadata.LDAPEntryObjectClassMetadataResolver;
import cz.integsoft.connectors.ldap.internal.operation.SearchOperationParameters;
import cz.integsoft.connectors.ldap.internal.service.EntrySearchServiceImpl;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

public abstract class AbstractSource
extends PollingSource<Map<String, Object>, Serializable> {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final String DISTINGUISHED_NAME = "dn";
    private static final String SORT_KEY = "sortKey";
    private EntrySearchServiceImpl ldapServiceImpl;
    @Config
    private LDAPConfiguration configuration;
    @Connection
    private ConnectionProvider<LDAPConnection> connectionProvider;
    private LDAPConnection ldapConnection;
    @Parameter
    @DisplayName(value="Base DN")
    private String baseDn;
    @Parameter
    @DisplayName(value="Filter")
    @org.mule.runtime.extension.api.annotation.param.Optional
    private String filter;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    private List<String> attributes;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="ONE_LEVEL")
    private SearchScope scope;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class)
    private String structuralObjectClass;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    private String since;
    private boolean isActiveDirectory;

    public boolean isActiveDirectory() {
        return this.isActiveDirectory;
    }

    protected void doStart() throws MuleException {
        this.ldapConnection = (LDAPConnection)this.connectionProvider.connect();
        this.ldapServiceImpl = new EntrySearchServiceImpl(this.configuration, this.ldapConnection);
        this.attributes.add(this.getWatermarkField());
        SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(this.baseDn, "(objectclass=*)", this.attributes, this.scope).setTimeout(0).setMaxResults(1L).setReturnObject(false).setReturnAttributes(false).setPageSize(0).setStructuralObjectClass(this.structuralObjectClass).build();
        List<Map<String, Object>> list = this.ldapServiceImpl.search(searchOperationParameters);
        if (list != null && !list.isEmpty() && (list.get(0).containsKey("modifyTimeStamp") || list.get(0).containsKey("createTimeStamp"))) {
            this.isActiveDirectory = true;
        }
        if (this.since == null || this.since.isEmpty()) {
            this.since = this.isActiveDirectory ? LocalDateTime.now(Clock.systemUTC()).format(DATETIME_FORMAT) + ".Z" : LocalDateTime.now(Clock.systemUTC()).format(DATETIME_FORMAT) + "Z";
        }
    }

    protected void doStop() {
        try {
            this.ldapConnection.disconnect();
        }
        catch (LDAPException lDAPException) {
            throw new ModuleException((ErrorTypeDefinition)LDAPErrorType.UNKNOWN, (Throwable)((Object)lDAPException));
        }
    }

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        String string;
        String string2 = "(" + this.getWatermarkField() + ">=" + this.since + ")";
        Optional optional = pollContext.getWatermark();
        if (optional.isPresent()) {
            string2 = "(" + this.getWatermarkField() + ">=" + String.valueOf(optional.get()).split("\\|\\|")[0] + ")";
        }
        String string3 = string = StringUtils.isBlank((String)this.filter) ? string2 : "(&" + this.filter + string2 + ")";
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        if (!this.attributes.contains(this.getWatermarkField())) {
            this.attributes.add(this.getWatermarkField());
        }
        try {
            SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(this.baseDn, string, this.attributes, this.scope).setTimeout(0).setMaxResults(0L).setReturnObject(false).setReturnAttributes(false).setPageSize(0).setStructuralObjectClass(this.structuralObjectClass).build();
            List<Map<String, Object>> list = this.ldapServiceImpl.search(searchOperationParameters);
            list.forEach(map -> map.put(SORT_KEY, map.get(this.getWatermarkField()) + "||" + map.get(DISTINGUISHED_NAME)));
            list.sort(Comparator.comparing(map -> String.valueOf(map.get(SORT_KEY))));
            list.forEach(map -> {
                String string = String.valueOf(map.remove(SORT_KEY));
                pollContext.accept(pollItem -> pollItem.setResult(this.toResult((Map<String, Object>)map)).setWatermark((Serializable)((Object)string)));
            });
        }
        catch (LDAPException lDAPException) {
            throw new ModuleException((ErrorTypeDefinition)LDAPErrorType.UNKNOWN, (Throwable)((Object)lDAPException));
        }
    }

    public void onRejectedItem(Result<Map<String, Object>, Serializable> result, SourceCallbackContext sourceCallbackContext) {
    }

    protected Result<Map<String, Object>, Serializable> toResult(Map<String, Object> map) {
        return Result.builder().output(map).build();
    }

    protected abstract String getWatermarkField();
}

