/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ActiveDirectoryUUIDByteParser {
    private ActiveDirectoryUUIDByteParser() {
    }

    public static String parseGUID(byte[] byArray) {
        return ActiveDirectoryUUIDByteParser.a(byArray[3] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[2] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[1] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[0] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.a(byArray[5] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[4] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.a(byArray[7] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[6] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.a(byArray[8] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[9] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.a(byArray[10] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[11] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[12] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[13] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[14] & 0xFF) + ActiveDirectoryUUIDByteParser.a(byArray[15] & 0xFF);
    }

    public static String parseSID(byte[] byArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder("S-");
        byte by = byArray[0];
        stringBuilder.append(by);
        int n2 = byArray[1] & 0xFF;
        long l = 0L;
        for (n = 2; n <= 7; ++n) {
            l |= (long)(byArray[n] << 8 * (5 - n - 2));
        }
        stringBuilder.append("-");
        stringBuilder.append(Long.toHexString(l));
        n = 8;
        int n3 = 4;
        for (int i = 0; i < n2; ++i) {
            long l2 = 0L;
            for (int j = 0; j < 4; ++j) {
                l2 |= (long)((byArray[n + j] & 0xFF) << 8 * j);
            }
            stringBuilder.append("-");
            stringBuilder.append(l2);
            n += 4;
        }
        return stringBuilder.toString();
    }

    private static String a(int n) {
        if (n <= 15) {
            return "0" + Integer.toHexString(n);
        }
        return Integer.toHexString(n);
    }

    public static String replaceGUIDWithADCompliantArray(String string) {
        CharSequence[] charSequenceArray = ActiveDirectoryUUIDByteParser.convertMSGUIDToHexFormat(string).split("(?<=\\G.{2})");
        String string2 = "\\";
        string2 = string2 + String.join((CharSequence)"\\", charSequenceArray);
        return string2;
    }

    public static String convertMSGUIDToHexFormat(String string) {
        string = string.replace("-", "");
        string = string.replaceAll("(.{8})(.{4})(.{4})(.{4})(.{12})", "$1-$2-$3-$4-$5").replaceAll("(.{2})(.{2})(.{2})(.{2}).(.{2})(.{2}).(.{2})(.{2})(.{18})", "$4$3$2$1-$6$5-$8$7$9");
        string = string.replace("-", "");
        return string;
    }

    public static String replaceFilterGUID(String string) {
        String string2 = "";
        Pattern pattern = Pattern.compile("[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
        }
        string = string.replace(string2, ActiveDirectoryUUIDByteParser.replaceGUIDWithADCompliantArray(string2));
        return string;
    }
}

