/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.util;

import cz.integsoft.connectors.ldap.api.SearchScope;
import cz.integsoft.connectors.ldap.internal.connection.LDAPSchemaAware;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntryAttributeTypeDefinition;
import cz.integsoft.connectors.ldap.internal.model.LDAPMultiValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.model.LDAPSingleValueEntryAttribute;
import cz.integsoft.connectors.ldap.internal.model.LDAPSortKey;
import cz.integsoft.connectors.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDAPJNDIUtils {
    private static final Logger bq = LoggerFactory.getLogger(LDAPJNDIUtils.class);

    private LDAPJNDIUtils() {
    }

    public static LDAPEntry buildEntry(String string, Attributes attributes) {
        return LDAPJNDIUtils.buildEntry(string, attributes, null);
    }

    public static LDAPEntry buildEntry(String string, Attributes attributes, LDAPSchemaAware lDAPSchemaAware) {
        LDAPEntry lDAPEntry = new LDAPEntry(string);
        if (attributes != null) {
            try {
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMore()) {
                    lDAPEntry.addAttribute(LDAPJNDIUtils.a((Attribute)namingEnumeration.nextElement(), lDAPSchemaAware));
                }
            }
            catch (NamingException namingException) {
                throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
            }
        }
        return lDAPEntry;
    }

    protected static LDAPEntryAttribute a(Attribute attribute, LDAPSchemaAware lDAPSchemaAware) {
        if (attribute == null) {
            return null;
        }
        LDAPEntryAttributeTypeDefinition lDAPEntryAttributeTypeDefinition = null;
        if (!attribute.getID().startsWith("member;range=")) {
            try {
                lDAPEntryAttributeTypeDefinition = lDAPSchemaAware != null ? lDAPSchemaAware.getAttributeTypeDefinition(attribute.getID()) : null;
            }
            catch (Exception exception) {
                bq.info("Ignore setting typeDefinition if it throws an exception ", (Throwable)exception);
            }
        }
        boolean bl = lDAPEntryAttributeTypeDefinition != null ? !lDAPEntryAttributeTypeDefinition.isSingleValue() : attribute.size() > 1;
        return LDAPJNDIUtils.a(attribute, lDAPEntryAttributeTypeDefinition, bl);
    }

    private static LDAPEntryAttribute a(Attribute attribute, LDAPEntryAttributeTypeDefinition lDAPEntryAttributeTypeDefinition, boolean bl) {
        try {
            if (bl) {
                LDAPMultiValueEntryAttribute lDAPMultiValueEntryAttribute = new LDAPMultiValueEntryAttribute();
                lDAPMultiValueEntryAttribute.setName(attribute.getID());
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    lDAPMultiValueEntryAttribute.addValue(namingEnumeration.next());
                }
                lDAPMultiValueEntryAttribute.setTypeDefinition(lDAPEntryAttributeTypeDefinition);
                return lDAPMultiValueEntryAttribute;
            }
            LDAPSingleValueEntryAttribute lDAPSingleValueEntryAttribute = new LDAPSingleValueEntryAttribute();
            lDAPSingleValueEntryAttribute.setName(attribute.getID());
            lDAPSingleValueEntryAttribute.setValue(LDAPJNDIUtils.a(attribute));
            lDAPSingleValueEntryAttribute.setTypeDefinition(lDAPEntryAttributeTypeDefinition);
            return lDAPSingleValueEntryAttribute;
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
    }

    private static Object a(Attribute attribute) throws NamingException {
        return attribute.size() != 0 ? attribute.get() : null;
    }

    private static String b(Attribute attribute) throws NamingException {
        Object object = LDAPJNDIUtils.a(attribute);
        return object != null ? object.toString() : null;
    }

    private static List<String> c(Attribute attribute) throws NamingException {
        if (attribute != null) {
            ArrayList<String> arrayList = new ArrayList<String>(attribute.size());
            for (int i = 0; i < attribute.size(); ++i) {
                Object object = attribute.get(i);
                if (object == null) continue;
                arrayList.add(object.toString());
            }
            return arrayList;
        }
        return null;
    }

    public static LDAPEntryObjectClassDefinition buildObjectClassDefinition(Attributes attributes) {
        LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition = null;
        if (attributes != null) {
            try {
                lDAPEntryObjectClassDefinition = new LDAPEntryObjectClassDefinition();
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMore()) {
                    Attribute attribute = (Attribute)namingEnumeration.nextElement();
                    String string = attribute.getID();
                    LDAPJNDIUtils.a(lDAPEntryObjectClassDefinition, attribute, string);
                }
            }
            catch (NamingException namingException) {
                throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
            }
        }
        return lDAPEntryObjectClassDefinition;
    }

    private static void a(LDAPEntryObjectClassDefinition lDAPEntryObjectClassDefinition, Attribute attribute, String string) throws NamingException {
        if (!"MAY".equalsIgnoreCase(string) && !"MUST".equalsIgnoreCase(string)) {
            String string2 = LDAPJNDIUtils.b(attribute);
            if (string != null && string2 != null) {
                lDAPEntryObjectClassDefinition.set(string, string2);
            }
        } else {
            List<String> list = LDAPJNDIUtils.c(attribute);
            if (list != null) {
                lDAPEntryObjectClassDefinition.set(string, list);
            }
        }
    }

    public static LDAPEntryAttributeTypeDefinition buildAttributeTypeDefinition(Attributes attributes) {
        LDAPEntryAttributeTypeDefinition lDAPEntryAttributeTypeDefinition = null;
        if (attributes != null) {
            try {
                lDAPEntryAttributeTypeDefinition = new LDAPEntryAttributeTypeDefinition();
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMore()) {
                    Attribute attribute = (Attribute)namingEnumeration.nextElement();
                    String string = attribute.getID();
                    String string2 = LDAPJNDIUtils.b(attribute);
                    if (string == null || string2 == null) continue;
                    lDAPEntryAttributeTypeDefinition.set(string, string2);
                }
            }
            catch (NamingException namingException) {
                throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
            }
        }
        return lDAPEntryAttributeTypeDefinition;
    }

    public static Control[] buildRequestControls(LDAPSearchControls lDAPSearchControls, byte[] byArray) {
        ArrayList<BasicControl> arrayList = new ArrayList<BasicControl>();
        try {
            if (lDAPSearchControls.isPagingEnabled()) {
                if (byArray != null) {
                    arrayList.add(new PagedResultsControl(lDAPSearchControls.getPageSize(), byArray, true));
                } else {
                    arrayList.add(new PagedResultsControl(lDAPSearchControls.getPageSize(), true));
                }
            }
            if (lDAPSearchControls.isSortEnabled()) {
                arrayList.add(new SortControl(LDAPJNDIUtils.b(lDAPSearchControls.getSortKeys()), true));
            }
            return arrayList.toArray(new Control[arrayList.size()]);
        }
        catch (IOException iOException) {
            throw new LDAPException("Could not create request paging or/and sort controls", LDAPErrorType.UNKNOWN, iOException);
        }
    }

    private static SortKey[] b(List<LDAPSortKey> list) {
        SortKey[] sortKeyArray = new SortKey[list.size()];
        int n = 0;
        for (LDAPSortKey lDAPSortKey : list) {
            sortKeyArray[n++] = new SortKey(lDAPSortKey.getAttributeName(), lDAPSortKey.isAscending(), lDAPSortKey.getMatchingRuleID());
        }
        return sortKeyArray;
    }

    public static SearchControls buildSearchControls(LDAPSearchControls lDAPSearchControls) {
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(lDAPSearchControls.getMaxResults());
        searchControls.setReturningAttributes(lDAPSearchControls.getAttributesToReturn());
        searchControls.setReturningObjFlag(lDAPSearchControls.isReturnObject());
        searchControls.setSearchScope(LDAPJNDIUtils.a(lDAPSearchControls.getScope()));
        searchControls.setTimeLimit(lDAPSearchControls.getTimeout());
        return searchControls;
    }

    private static int a(SearchScope searchScope) {
        return searchScope.getValue();
    }

    public static boolean containsDnValue(String string, List<Object> list) {
        LdapName ldapName = LDAPJNDIUtils.g(string);
        if (ldapName != null && list != null && !list.isEmpty()) {
            for (Object object : list) {
                if (!(object instanceof String) || !ldapName.equals(LDAPJNDIUtils.g((String)object))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static LdapName g(String string) {
        try {
            return new LdapName(string);
        }
        catch (InvalidNameException invalidNameException) {
            bq.warn("Invalid DN.");
            return null;
        }
    }

    public static String escapeMetaCharacters(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"+", "<", ">"}) {
            if (string == null || !string.contains(string2)) continue;
            string = string.replace(string2, "\\" + string2);
        }
        return string;
    }

    public static TrustManager[] getCustomTrustStoreWithDefaultCerts(Optional<File> optional, String string) throws Exception {
        KeyStore keyStore = LDAPJNDIUtils.a(optional, string);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        List<TrustManager> list = Arrays.asList(trustManagerFactory.getTrustManagers());
        List list2 = list.stream().filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).map(x509TrustManager -> Arrays.asList(x509TrustManager.getAcceptedIssuers())).flatMap(Collection::stream).collect(Collectors.toList());
        for (X509Certificate x509Certificate : list2) {
            keyStore.setCertificateEntry(String.valueOf(x509Certificate.getSerialNumber()), x509Certificate);
        }
        TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory2.init(keyStore);
        return trustManagerFactory2.getTrustManagers();
    }

    private static KeyStore a(Optional<File> optional, String string) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        try (FileInputStream fileInputStream = new FileInputStream(optional.get());){
            keyStore.load(fileInputStream, string.toCharArray());
        }
        return keyStore;
    }
}

