/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPTrustManager
implements X509TrustManager {
    private X509TrustManager bs;
    private static final Logger bt = LoggerFactory.getLogger(LDAPTrustManager.class);

    public LDAPTrustManager(File file, String string) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustManagerArray;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            trustManagerArray = new FileInputStream(file);
            Throwable throwable = null;
            try {
                keyStore.load((InputStream)trustManagerArray, string.toCharArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (trustManagerArray != null) {
                    if (throwable != null) {
                        try {
                            trustManagerArray.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        trustManagerArray.close();
                    }
                }
            }
        }
        catch (IOException | CertificateException exception) {
            bt.debug(exception.getMessage(), (Throwable)exception);
        }
        trustManagerFactory.init(keyStore);
        trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            this.bs = (X509TrustManager)trustManagerArray[i];
            return;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.bs.checkServerTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

