/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.util;

import cz.integsoft.connectors.ldap.internal.connection.LDAPSchemaAware;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.util.LDAPJNDIUtils;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSet;
import cz.integsoft.connectors.ldap.internal.util.LDAPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsResponseControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedLDAPResultSet
implements LDAPResultSet {
    private static final Logger bv = LoggerFactory.getLogger(PagedLDAPResultSet.class);
    private final String bw;
    private final String bx;
    private final Object[] by;
    private LdapContext K;
    private final LDAPSearchControls bz;
    private LDAPSchemaAware bA = null;
    private final boolean bB;
    private boolean bC;
    private NamingEnumeration<SearchResult> bD = null;
    private byte[] bE = null;

    public PagedLDAPResultSet(String string, String string2, Object[] objectArray, LdapContext ldapContext, LDAPSearchControls lDAPSearchControls, NamingEnumeration<SearchResult> namingEnumeration, LDAPSchemaAware lDAPSchemaAware) {
        this.bw = string;
        this.bx = string2;
        this.by = objectArray != null ? (Object[])objectArray.clone() : new Object[]{};
        this.bz = lDAPSearchControls;
        this.K = ldapContext;
        this.bA = lDAPSchemaAware;
        this.bD = namingEnumeration;
        this.bB = LDAPUtils.containsDn(lDAPSearchControls);
        this.bC = false;
    }

    @Override
    public void close() {
        try {
            this.h();
        }
        finally {
            this.bA = null;
            if (this.K != null) {
                try {
                    this.K.close();
                }
                catch (NamingException namingException) {
                    throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
                }
                finally {
                    this.K = null;
                }
            }
        }
    }

    private void h() {
        try {
            if (this.bD != null) {
                this.bD.close();
            }
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
        finally {
            this.bD = null;
        }
    }

    @Override
    public LDAPEntry next() {
        SearchResult searchResult;
        if (this.hasNext() && (searchResult = (SearchResult)this.bD.nextElement()) != null) {
            String string = searchResult.getName();
            if (searchResult.isRelative()) {
                string = string + "," + this.bw;
            }
            LDAPEntry lDAPEntry = LDAPJNDIUtils.buildEntry(string, searchResult.getAttributes(), this.bA);
            if (!this.bB) {
                lDAPEntry.setDn(null);
            }
            return lDAPEntry;
        }
        throw new NoSuchElementException("End of result set");
    }

    private void i() {
        try {
            this.j();
            this.K.setRequestControls(LDAPJNDIUtils.buildRequestControls(this.bz, this.bE));
            this.bD = this.by != null && this.by.length > 0 ? this.K.search(this.bw, this.bx, this.by, LDAPJNDIUtils.buildSearchControls(this.bz)) : this.K.search(this.bw, this.bx, LDAPJNDIUtils.buildSearchControls(this.bz));
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
    }

    private void j() {
        if (this.bD != null) {
            try {
                this.bD.close();
            }
            catch (NamingException namingException) {
                bv.error("Naming exception", (Throwable)namingException);
            }
            finally {
                this.bD = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.bD != null && !this.bC) {
                if (!this.bD.hasMore()) {
                    this.bE = this.l();
                    if (this.bE != null) {
                        this.i();
                        return this.bD != null && this.bD.hasMore();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            bv.warn("Size limit exceeded. Max results is: " + this.bz.getMaxResults());
            bv.debug(sizeLimitExceededException.getMessage());
            this.bC = true;
            return false;
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
    }

    private int k() {
        try {
            Control[] controlArray = this.K.getResponseControls();
            if (controlArray != null) {
                for (Control control : controlArray) {
                    if (!(control instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)control;
                    return pagedResultsResponseControl.getResultSize();
                }
            }
            return -1;
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
    }

    private byte[] l() {
        try {
            Control[] controlArray = this.K.getResponseControls();
            if (controlArray != null) {
                for (Control control : controlArray) {
                    if (!(control instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)control;
                    return pagedResultsResponseControl.getCookie();
                }
            }
            return null;
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
    }

    @Override
    public List<LDAPEntry> getAllEntries() {
        ArrayList<LDAPEntry> arrayList = new ArrayList<LDAPEntry>();
        while (this.hasNext()) {
            LDAPEntry lDAPEntry = this.next();
            if (lDAPEntry == null) continue;
            arrayList.add(lDAPEntry);
        }
        return arrayList;
    }

    @Override
    public int getResultSize() {
        return this.k();
    }

    @Override
    public boolean isLastElement() {
        return this.bC;
    }
}

