/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.connectors.ldap.internal.util;

import cz.integsoft.connectors.ldap.internal.connection.LDAPSchemaAware;
import cz.integsoft.connectors.ldap.internal.error.LDAPErrorType;
import cz.integsoft.connectors.ldap.internal.error.exception.LDAPException;
import cz.integsoft.connectors.ldap.internal.model.LDAPEntry;
import cz.integsoft.connectors.ldap.internal.model.LDAPSearchControls;
import cz.integsoft.connectors.ldap.internal.util.LDAPJNDIUtils;
import cz.integsoft.connectors.ldap.internal.util.LDAPResultSet;
import cz.integsoft.connectors.ldap.internal.util.LDAPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLDAPResultSet
implements LDAPResultSet {
    private static final Logger bF = LoggerFactory.getLogger(SimpleLDAPResultSet.class);
    private NamingEnumeration<SearchResult> bD = null;
    private String baseDn = null;
    private LDAPSearchControls aY = null;
    private LDAPSchemaAware bA;
    private boolean bB = false;

    public SimpleLDAPResultSet(String string, LDAPSearchControls lDAPSearchControls, NamingEnumeration<SearchResult> namingEnumeration, LDAPSchemaAware lDAPSchemaAware) {
        this.bD = namingEnumeration;
        this.baseDn = string;
        this.aY = lDAPSearchControls;
        this.bA = lDAPSchemaAware;
        this.bB = LDAPUtils.containsDn(lDAPSearchControls);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.bD != null && this.bD.hasMore();
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            bF.warn("Size limit exceeded. Max results is:{}  {} ", (Object)this.aY.getMaxResults(), (Object)sizeLimitExceededException);
            return false;
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
    }

    @Override
    public LDAPEntry next() {
        SearchResult searchResult = (SearchResult)this.bD.nextElement();
        if (searchResult != null) {
            String string = searchResult.getName();
            if (searchResult.isRelative()) {
                string = string + "," + this.baseDn;
            }
            LDAPEntry lDAPEntry = LDAPJNDIUtils.buildEntry(string, searchResult.getAttributes(), this.bA);
            if (!this.bB) {
                lDAPEntry.setDn(null);
            }
            return lDAPEntry;
        }
        throw new NoSuchElementException("End of result set");
    }

    @Override
    public void close() {
        try {
            if (this.bD != null) {
                this.bD.close();
            }
        }
        catch (NamingException namingException) {
            throw new LDAPException(LDAPErrorType.UNKNOWN, namingException);
        }
        finally {
            this.bD = null;
            this.bA = null;
        }
    }

    @Override
    public List<LDAPEntry> getAllEntries() {
        ArrayList<LDAPEntry> arrayList = new ArrayList<LDAPEntry>();
        while (this.hasNext()) {
            LDAPEntry lDAPEntry = this.next();
            if (lDAPEntry != null) {
                arrayList.add(lDAPEntry);
            }
            if (this.bD.hasMoreElements()) continue;
            break;
        }
        return arrayList;
    }

    @Override
    public int getResultSize() {
        return -1;
    }

    @Override
    public boolean isLastElement() {
        return false;
    }
}

