/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal;

import cz.integsoft.mule.license.api.AbstractLicenseHelper;
import cz.integsoft.mule.license.api.exception.LicenseManagementException;
import cz.integsoft.mule.license.api.exception.NoLicenseAvailableException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.el.ExpressionManager;

public class IpmLicenseHelper
extends AbstractLicenseHelper {
    @Inject
    private ExpressionManager Z;

    public void dispose() {
        LOGGER.debug("Returning license {} back to the pool.", (Object)this.currentLicense);
        try {
            boolean bl = this.licenseManager.release(this.currentLicense, this.componentName, this.componentVersion, this.applicationName);
            if (bl) {
                LOGGER.info("The license {} has been returned back to the license pool.", (Object)this.currentLicense);
            } else {
                LOGGER.warn("Failed to return the license {} back to the license pool.", (Object)this.currentLicense);
            }
        }
        catch (LicenseManagementException licenseManagementException) {
            LOGGER.error("Failed to return license back to the pool.", (Throwable)licenseManagementException);
        }
    }

    public void initialise() throws InitialisationException {
        try {
            LOGGER.info("Initializing license helper");
            super.initialise();
            BindingContext.Builder builder = BindingContext.builder();
            this.componentName = "IPM";
            this.componentVersion = this.t();
            this.applicationName = (String)this.Z.evaluate("#[app.name]", builder.build()).getValue();
            LOGGER.debug("License helper {}", (Object)this);
            this.currentLicense = this.licenseManager.borrow(this.componentName, this.componentVersion, this.applicationName);
            LOGGER.info("Initializing license helper done {}", (Object)this);
        }
        catch (NoLicenseAvailableException noLicenseAvailableException) {
            throw new InitialisationException((Throwable)noLicenseAvailableException, (Initialisable)this);
        }
        catch (LicenseManagementException licenseManagementException) {
            throw new InitialisationException((Throwable)licenseManagementException, (Initialisable)this);
        }
        catch (Exception exception) {
            throw new InitialisationException((Throwable)exception, (Initialisable)this);
        }
    }

    private String t() throws URISyntaxException, IOException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("version"), "UTF-8"));){
            String string = bufferedReader.readLine();
            return string;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IpmLicenseHelper [applicationName=");
        stringBuilder.append(this.applicationName);
        stringBuilder.append(", componentName=");
        stringBuilder.append(this.componentName);
        stringBuilder.append(", componentVersion=");
        stringBuilder.append(this.componentVersion);
        stringBuilder.append(", currentLicense=");
        stringBuilder.append(this.currentLicense);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

