/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.failover.operation;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.exception.CircuitOpenException;
import cz.integsoft.mule.ipm.api.exception.InitializationException;
import cz.integsoft.mule.ipm.api.failover.CircuitBreakerAttributes;
import cz.integsoft.mule.ipm.api.failover.FailoverEvent;
import cz.integsoft.mule.ipm.api.failover.FailoverHost;
import cz.integsoft.mule.ipm.api.failover.FailoverManager;
import cz.integsoft.mule.ipm.api.failover.FailoverNotificationObserver;
import cz.integsoft.mule.ipm.internal.AbstractOperation;
import cz.integsoft.mule.ipm.internal.error.FailoverErrorTypeProvider;
import cz.integsoft.mule.ipm.internal.failover.CircuitBreakerRoute;
import cz.integsoft.mule.ipm.internal.failover.parameter.CircuitBreakerParameters;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreaker
extends AbstractOperation
implements FailoverNotificationObserver<FailoverHost>,
Initialisable,
Startable,
Stoppable {
    private static final Logger ah = LoggerFactory.getLogger(CircuitBreaker.class);
    @Inject
    private Registry ai;
    private CircuitState aj;
    private Flow ak;
    private Flow al;
    private Flow am;
    private Flow an;
    private final ReentrantLock ao = new ReentrantLock(true);
    @ParameterGroup(name="Circuit Breaker Parameters")
    private CircuitBreakerParameters ap;

    @Throws(value={FailoverErrorTypeProvider.class})
    @Alias(value="circuit-breaker")
    public void a(@Alias(value="route") CircuitBreakerRoute circuitBreakerRoute, RouterCompletionCallback routerCompletionCallback) {
        this.s();
        if (this.ap.isEnabled()) {
            ah.debug("Using failover manager: {}", this.ap.getFailoverManager());
            ah.debug("Circuit breaker state: {}", (Object)this.u());
            if (CircuitState.OPEN.equals((Object)this.u())) {
                throw new CircuitOpenException(ProxyErrorCode.IPM_ANY_010, "Circuit breaker is open. This means that the inner route is not available right now, please try later.");
            }
            circuitBreakerRoute.getChain().process(arg_0 -> ((RouterCompletionCallback)routerCompletionCallback).success(arg_0), (throwable, result) -> routerCompletionCallback.error(throwable));
        } else {
            circuitBreakerRoute.getChain().process(arg_0 -> ((RouterCompletionCallback)routerCompletionCallback).success(arg_0), (throwable, result) -> routerCompletionCallback.error(throwable));
        }
    }

    public void initialise() throws InitialisationException {
        Optional optional;
        if (this.ap.getOnClose() != null) {
            optional = this.ai.lookupByName(this.ap.getOnClose());
            if (!optional.isPresent()) {
                throw new InitializationException(ProxyErrorCode.IPM_ANY_009, MessageFormat.format("onClose handler flow not found: {0}", this.ap.getOnClose()));
            }
            this.ak = (Flow)optional.get();
        }
        if (this.ap.getOnOpen() != null) {
            optional = this.ai.lookupByName(this.ap.getOnOpen());
            if (!optional.isPresent()) {
                throw new InitializationException(ProxyErrorCode.IPM_ANY_009, MessageFormat.format("onOpen handler flow not found: {0}", this.ap.getOnOpen()));
            }
            this.al = (Flow)optional.get();
        }
        if (this.ap.getOnHostDown() != null) {
            optional = this.ai.lookupByName(this.ap.getOnHostDown());
            if (!optional.isPresent()) {
                throw new InitializationException(ProxyErrorCode.IPM_ANY_009, MessageFormat.format("onHostDown handler flow not found: {0}", this.ap.getOnHostDown()));
            }
            this.an = (Flow)optional.get();
        }
        if (this.ap.getOnHostUp() != null) {
            optional = this.ai.lookupByName(this.ap.getOnHostUp());
            if (!optional.isPresent()) {
                throw new InitializationException(ProxyErrorCode.IPM_ANY_009, MessageFormat.format("onHostUp handler flow not found: {0}", this.ap.getOnHostUp()));
            }
            this.am = (Flow)optional.get();
        }
    }

    public void stop() throws MuleException {
        this.ap.getFailoverManager().unregisterObserver(this);
        this.aj = CircuitState.OPEN;
        ah.debug("Stopped circuit breaker {}", (Object)this);
    }

    public void start() throws MuleException {
        this.ap.getFailoverManager().registerObserver(this);
        this.aj = CircuitState.CLOSED;
        ah.debug("Started circuit breaker {}", (Object)this);
    }

    @Ignore
    public void a(FailoverEvent failoverEvent, FailoverManager<FailoverHost> failoverManager, FailoverHost failoverHost) {
        if (this.ap.isEnabled()) {
            ah.debug("Circuit breaker {} has been notified from {}: event={} host={}", new Object[]{this, failoverManager, failoverEvent, failoverHost});
            CircuitBreakerAttributes circuitBreakerAttributes = new CircuitBreakerAttributes(failoverEvent, failoverHost, Instant.now().toEpochMilli());
            switch (failoverEvent) {
                case HOST_DOWN: {
                    this.a(this.an, null, circuitBreakerAttributes, new HashMap<String, Object>());
                    break;
                }
                case HOST_UP: {
                    this.a(this.am, null, circuitBreakerAttributes, new HashMap<String, Object>());
                    if (CircuitState.CLOSED.equals((Object)this.u())) break;
                    this.a(CircuitState.CLOSED);
                    this.a(this.ak, null, circuitBreakerAttributes, new HashMap<String, Object>());
                    break;
                }
                case NO_HOST_AVAILABLE: {
                    if (CircuitState.OPEN.equals((Object)this.u())) break;
                    this.a(CircuitState.OPEN);
                    this.a(this.al, null, circuitBreakerAttributes, new HashMap<String, Object>());
                    break;
                }
            }
        }
    }

    private void a(Flow flow, Object object, CircuitBreakerAttributes circuitBreakerAttributes, Map<String, Object> map) {
        if (flow != null) {
            try {
                flow.execute(InputEvent.create().message(Message.builder().payload(TypedValue.of((Object)object)).attributes(TypedValue.of((Object)circuitBreakerAttributes)).build()).variables(map)).whenCompleteAsync((executionResult, throwable) -> {
                    if (executionResult != null) {
                        ah.debug("Completing handler execution");
                        executionResult.complete();
                    } else {
                        ah.warn("Problem completing handler execution");
                    }
                });
            }
            catch (Exception exception) {
                ah.error("Error while executing handler.", (Throwable)exception);
            }
        }
    }

    private void a(CircuitState circuitState) {
        try {
            this.ao.lock();
            if (this.aj != circuitState) {
                ah.debug("Circuit breaker state transition: {} -> {}", (Object)this.aj, (Object)circuitState);
                this.aj = circuitState;
            }
        }
        finally {
            this.ao.unlock();
        }
    }

    @Ignore
    public CircuitState u() {
        try {
            this.ao.lock();
            CircuitState circuitState = this.aj;
            return circuitState;
        }
        finally {
            this.ao.unlock();
        }
    }

    @Override
    @Ignore
    public /* synthetic */ void notify(FailoverEvent failoverEvent, FailoverManager failoverManager, Object object) {
        this.a(failoverEvent, failoverManager, (FailoverHost)object);
    }

    private static enum CircuitState {
        OPEN,
        CLOSED;

    }
}

