/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http;

import cz.integsoft.mule.ipm.internal.http.ShareableHttpClient;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConnectionManager
implements Disposable {
    @Inject
    private HttpService httpService;
    private final Map<String, ShareableHttpClient> clients = new ConcurrentHashMap<String, ShareableHttpClient>();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientConnectionManager.class);

    public HttpClientConnectionManager() {
    }

    public HttpClientConnectionManager(HttpService httpService) {
        this.httpService = httpService;
    }

    @Deprecated
    public Optional<ShareableHttpClient> lookup(String string) {
        return Optional.ofNullable(this.clients.get(string));
    }

    @Deprecated
    public synchronized ShareableHttpClient create(String string, HttpClientConfiguration httpClientConfiguration) {
        Preconditions.checkArgument((!this.clients.containsKey(string) ? 1 : 0) != 0, (String)String.format("There's an HttpClient available for %s already.", string));
        ShareableHttpClient shareableHttpClient = new ShareableHttpClient(this.httpService.getClientFactory().create(httpClientConfiguration));
        this.clients.put(string, shareableHttpClient);
        return shareableHttpClient;
    }

    public void dispose() {
        LOGGER.info("Disposing HTTP client connection manager {} with {} factories inside", (Object)this, (Object)this.clients.size());
        this.clients.clear();
    }

    public synchronized ShareableHttpClient lookupOrCreate(String string2, Supplier<? extends HttpClientConfiguration> supplier) {
        return this.clients.computeIfAbsent(string2, string -> new ShareableHttpClient(this.httpService.getClientFactory().create((HttpClientConfiguration)supplier.get())));
    }

    public synchronized void disposeClient(String string) {
        this.clients.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(string));
    }
}

