/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http.config;

import cz.integsoft.mule.ipm.api.http.authentication.HttpRequestAuthentication;
import cz.integsoft.mule.ipm.api.http.parameter.ClientKeystore;
import cz.integsoft.mule.ipm.api.http.parameter.HttpHeader;
import cz.integsoft.mule.ipm.api.http.parameter.ServerKeystore;
import cz.integsoft.mule.ipm.api.http.proxy.ViaHttpProxyConfig;
import cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties;
import cz.integsoft.mule.ipm.internal.http.HttpClientConnectionManager;
import cz.integsoft.mule.ipm.internal.http.operation.HttpProxyOperation;
import cz.integsoft.mule.ipm.internal.http.parameter.KeyStoreHolder;
import cz.integsoft.mule.ipm.internal.http.parameter.KeyStoreMappingHolder;
import cz.integsoft.mule.ipm.internal.http.parameter.SslProtocolValueProvider;
import java.net.CookieManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={HttpProxyOperation.class})
@Configuration(name="http-proxy-config")
@ExternalLibs(value={@ExternalLib(name="Spring Core", coordinates="org.springframework:spring-core:[5.1.0.RELEASE,)", type=ExternalLibraryType.DEPENDENCY)})
@Import(type=HttpResponseAttributes.class)
public class HttpProxyConfig
implements Disposable,
Initialisable {
    private static final Logger aL = LoggerFactory.getLogger(HttpProxyConfig.class);
    private static final String aM = "-1";
    @Deprecated
    private static final String aN = "10";
    private static final String aO = "30000";
    private static final String aP = "-1";
    private static final String aQ = "-1";
    @RefName
    private String configName;
    @Inject
    private HttpClientConnectionManager aR;
    @Inject
    private MuleContext aS;
    private CookieManager aT;
    @Parameter
    @Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    @Alias(value="via-proxy")
    private ViaHttpProxyConfig aU;
    @Parameter
    @Optional
    @Placement(tab="TLS")
    @Alias(value="authentication")
    private HttpRequestAuthentication aD;
    @Parameter
    @Optional
    @Alias(value="server-keystore")
    private ServerKeystore aV;
    @Parameter
    @Optional
    @Alias(value="client-keystores")
    private final List<ClientKeystore> aW = Collections.emptyList();
    private KeyStoreHolder aX;
    private List<KeyStoreMappingHolder> aY;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=1)
    @Alias(value="max-connections")
    private Integer aZ;
    @Parameter
    @Optional(defaultValue="10")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=2)
    @Alias(value="max-connections-per-route")
    @Summary(value="Deprecated, not used and has no effect.")
    @Deprecated
    private Integer ba;
    @Parameter
    @Optional(defaultValue="30000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=3)
    @Alias(value="connection-idle-timeout")
    private Integer bb;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=4)
    @Alias(value="connection-ttl")
    private Integer bc;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=5)
    @Alias(value="tcp-client-socket-properties")
    private TcpClientSocketProperties bd;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    @Alias(value="enable-cookies")
    private boolean be;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=7)
    @Alias(value="connection-request-timeout")
    private Integer bf;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=8)
    private boolean bg;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=9)
    @Alias(value="response-buffer-size")
    private int bh;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=10)
    @Alias(value="stream-response")
    private boolean bi;
    @Parameter
    @OfValues(value=SslProtocolValueProvider.class)
    @Optional(defaultValue="TLSv1.2")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="TLS", order=1)
    @Alias(value="ssl-protocol", description="Defines SSL protocol. One of these protocols is supported: SSLv3, TLSv1, TLSv1.1 and TLSv1.2. Default is TLSv1.2.")
    private String bj;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="TLS", order=2)
    @Alias(value="trust-all", description="Set to true to disable trust check on the SSL endpoint.")
    private boolean bk;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Connection")
    @Alias(value="follow-redirects")
    private boolean bl;
    @Parameter
    @Optional
    @NullSafe
    @Alias(value="default-http-headers")
    private List<HttpHeader> bm;

    public void initialise() throws InitialisationException {
        aL.info("Initializing config with name " + this.configName);
        aL.debug("Server keystore: {}", (Object)this.aV);
        if (this.aV != null) {
            aL.info("Initializing custom trust store {}", (Object)this.aV);
            this.aX = new KeyStoreHolder(this.aV.b(), this.aV.getPassword());
            this.aX.ae();
        }
        aL.info("Initializing server keystore done");
        aL.debug("Client keystores: {}", (Object)this.aW.stream().map(clientKeystore -> clientKeystore.toString()).collect(Collectors.joining("\n")));
        this.aY = new LinkedList<KeyStoreMappingHolder>();
        this.aW.forEach(clientKeystore -> {
            KeyStoreMappingHolder keyStoreMappingHolder = new KeyStoreMappingHolder(clientKeystore.b(), clientKeystore.getPassword(), clientKeystore.d(), clientKeystore.c(), clientKeystore.e());
            keyStoreMappingHolder.ae();
            this.aY.add(keyStoreMappingHolder);
        });
        if (this.I()) {
            this.aT = new CookieManager();
        }
        aL.info("Initializing client keystores done");
        aL.info("Initializing config with name " + this.configName + " done");
    }

    public void dispose() {
        this.aR.disposeClient(this.aS.getId() + "_" + this.configName);
    }

    public String getConfigName() {
        return this.configName;
    }

    public KeyStoreHolder y() {
        return this.aX;
    }

    public List<KeyStoreMappingHolder> z() {
        return this.aY;
    }

    public ServerKeystore A() {
        return this.aV;
    }

    public final boolean B() {
        return this.bg;
    }

    public Integer C() {
        return this.aZ;
    }

    public final CookieManager D() {
        return this.aT;
    }

    public Integer E() {
        return this.ba;
    }

    public Integer F() {
        return this.bb;
    }

    public Integer G() {
        return this.bc;
    }

    public TcpClientSocketProperties H() {
        return this.bd;
    }

    public boolean I() {
        return this.be;
    }

    public boolean J() {
        return this.bl;
    }

    public String K() {
        return this.bj;
    }

    public boolean L() {
        return this.bk;
    }

    public final boolean M() {
        return this.bi;
    }

    public final int N() {
        return this.bh;
    }

    public final List<ClientKeystore> O() {
        return this.aW;
    }

    public ViaHttpProxyConfig P() {
        return this.aU;
    }

    public HttpRequestAuthentication Q() {
        return this.aD;
    }

    public List<HttpHeader> R() {
        return this.bm;
    }

    public final Integer S() {
        return this.bf;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpProxyConfig [configName=");
        stringBuilder.append(this.configName);
        stringBuilder.append(", viaProxyConfig=");
        stringBuilder.append(this.aU);
        stringBuilder.append(", serverKeystore=");
        stringBuilder.append(this.aV);
        stringBuilder.append(", clientKeystores=");
        stringBuilder.append(this.aW);
        stringBuilder.append(", trustStoreHolder=");
        stringBuilder.append(this.aX);
        stringBuilder.append(", clientKeystoreHolders=");
        stringBuilder.append(this.aY);
        stringBuilder.append(", maxConnections=");
        stringBuilder.append(this.aZ);
        stringBuilder.append(", maxConnectionsPerRoute=");
        stringBuilder.append(this.ba);
        stringBuilder.append(", connectionIdleTimeout=");
        stringBuilder.append(this.bb);
        stringBuilder.append(", connectionTimeToLive=");
        stringBuilder.append(this.bc);
        stringBuilder.append(", connectionRequestTimeout=");
        stringBuilder.append(this.bf);
        stringBuilder.append(", streamResponse=");
        stringBuilder.append(this.bi);
        stringBuilder.append(", clientSocketProperties=");
        stringBuilder.append(this.bd);
        stringBuilder.append(", enableCookies=");
        stringBuilder.append(this.be);
        stringBuilder.append(", sslProtocol=");
        stringBuilder.append(this.bj);
        stringBuilder.append(", trustAll=");
        stringBuilder.append(this.bk);
        stringBuilder.append(", followRedirects=");
        stringBuilder.append(this.bl);
        stringBuilder.append(", authentication=");
        stringBuilder.append(this.aD);
        stringBuilder.append(", responseBufferSize");
        stringBuilder.append(this.bh);
        stringBuilder.append(", usePersistentConnections");
        stringBuilder.append(this.bg);
        stringBuilder.append(", cookieManager");
        stringBuilder.append(this.aT);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

