/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http.operation;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.exception.ProcessingException;
import cz.integsoft.mule.ipm.api.exception.ReadTimeoutException;
import cz.integsoft.mule.ipm.api.http.HttpSendBodyMode;
import cz.integsoft.mule.ipm.api.http.HttpStreamingType;
import cz.integsoft.mule.ipm.api.http.ProxyHttpResponseAttributes;
import cz.integsoft.mule.ipm.api.http.authentication.HttpRequestAuthentication;
import cz.integsoft.mule.ipm.api.http.parameter.UriParameters;
import cz.integsoft.mule.ipm.api.http.proxy.ViaHttpProxyConfig;
import cz.integsoft.mule.ipm.internal.http.HttpExtensionClient;
import cz.integsoft.mule.ipm.internal.http.OffsetCursorProviderWrapper;
import cz.integsoft.mule.ipm.internal.http.config.HttpProxyConfig;
import cz.integsoft.mule.ipm.internal.http.parameter.ExclusiveHttpHeaders;
import cz.integsoft.mule.ipm.internal.http.parameter.HttpRequestParameter;
import cz.integsoft.mule.ipm.internal.http.parameter.KeyStoreMappingHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyOperationDelegate {
    private static final int br = 80;
    private static final int bs = 443;
    private static final Charset bt = Charset.defaultCharset();
    private static final Logger bu = LoggerFactory.getLogger(HttpProxyOperationDelegate.class);
    private static final Logger bv = LoggerFactory.getLogger((String)"IPM_HTTP_WIRE_LOG");
    private static final String bw = "ipm.requester.%s";
    private static final Set<String> bx = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS")));
    private static final String by = "Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.";
    private static final String bz = "Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER.";
    private static final String bA = "Transfer-Encoding header value was invalid and will not be sent.";
    private static final String bB = "Cookie".toLowerCase();
    private static final String bC = "; ";

    public void a(TypedValue<?> typedValue, ExclusiveHttpHeaders exclusiveHttpHeaders, HttpRequestParameter httpRequestParameter, HttpRequestAttributes httpRequestAttributes, HttpExtensionClient httpExtensionClient, URI uRI, HttpProxyConfig httpProxyConfig, CompletionCallback<Object, ProxyHttpResponseAttributes> completionCallback, StreamingHelper streamingHelper, HttpSendBodyMode httpSendBodyMode, HttpStreamingType httpStreamingType, TransformationService transformationService) throws IOException {
        HttpRequest httpRequest = this.a(typedValue, exclusiveHttpHeaders, httpRequestParameter, httpRequestAttributes, uRI, httpProxyConfig, httpSendBodyMode, httpStreamingType, transformationService);
        httpExtensionClient.a(httpRequest, httpRequestParameter.ab() == null ? httpProxyConfig.H().j() : httpRequestParameter.ab(), httpProxyConfig.J(), this.a(httpExtensionClient.w()), httpSendBodyMode).whenComplete((httpResponse, throwable) -> {
            block14: {
                try {
                    if (httpResponse != null) {
                        if (httpProxyConfig.I()) {
                            this.a(httpProxyConfig, (HttpResponse)httpResponse, uRI);
                        }
                        try {
                            HttpEntity httpEntity = httpResponse.getEntity();
                            Supplier<Object> supplier = this.a(streamingHelper, httpEntity);
                            String string = httpResponse.getHeaderValue("Content-Type");
                            int n = httpResponse.getStatusCode();
                            ProxyHttpResponseAttributes proxyHttpResponseAttributes = new ProxyHttpResponseAttributes(n, httpResponse.getReasonPhrase(), (MultiMap<String, String>)httpResponse.getHeaders(), httpRequest.getMethod(), uRI.toString(), (MultiMap<String, String>)httpRequest.getHeaders());
                            if (httpEntity != null && !(httpEntity instanceof EmptyHttpEntity)) {
                                bu.debug("Got response entity: {} isStreaming: {}", (Object)httpEntity, (Object)httpEntity.isStreaming());
                                completionCallback.success(Result.builder().output(supplier.get()).attributes((Object)proxyHttpResponseAttributes).mediaType(string == null ? MediaType.ANY : MediaType.parse((String)string)).build());
                                break block14;
                            }
                            bu.debug("Entity is null");
                            completionCallback.success(Result.builder().attributes((Object)proxyHttpResponseAttributes).mediaType(string == null ? MediaType.ANY : MediaType.parse((String)string)).build());
                        }
                        catch (Exception exception) {
                            completionCallback.error((Throwable)((Object)new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while processing http response from " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                        }
                        break block14;
                    }
                    this.a((Throwable)throwable, httpExtensionClient.v());
                    if (throwable instanceof TimeoutException) {
                        completionCallback.error((Throwable)((Object)new ReadTimeoutException(ProxyErrorCode.IPM_SND_002, "Read timeout occurred while sending http request to " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                    } else {
                        completionCallback.error((Throwable)((Object)new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while sending http request to " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                    }
                }
                finally {
                    block15: {
                        try {
                            httpExtensionClient.stop();
                        }
                        catch (MuleException muleException) {
                            if (!bu.isWarnEnabled()) break block15;
                            bu.warn("Found exception trying to stop http client: " + muleException.getMessage(), (Throwable)muleException);
                        }
                    }
                }
            }
        });
    }

    private HttpRequest a(TypedValue<?> typedValue, ExclusiveHttpHeaders exclusiveHttpHeaders, HttpRequestParameter httpRequestParameter, HttpRequestAttributes httpRequestAttributes, URI uRI, HttpProxyConfig httpProxyConfig, HttpSendBodyMode httpSendBodyMode, HttpStreamingType httpStreamingType, TransformationService transformationService) throws IOException {
        String string = StringUtils.isBlank((CharSequence)httpRequestParameter.Y()) ? httpRequestAttributes.getMethod() : httpRequestParameter.Y();
        HttpRequestBuilder httpRequestBuilder = HttpRequest.builder();
        httpRequestBuilder.uri(uRI).method(string);
        httpRequestParameter.X().entrySet().forEach(entry -> {
            bu.debug("Adding query parameter {}:{}", entry.getKey(), entry.getValue());
            httpRequestBuilder.addQueryParam((String)entry.getKey(), (String)entry.getValue());
        });
        exclusiveHttpHeaders.V().forEach(httpHeader -> {
            if (StringUtils.isNotBlank((CharSequence)httpHeader.getValue())) {
                bu.debug("Adding request header {}:{}", (Object)httpHeader.getKey(), (Object)httpHeader.getValue());
                httpRequestBuilder.addHeader(httpHeader.getKey(), httpHeader.getValue());
            }
        });
        exclusiveHttpHeaders.W().entrySet().forEach(entry -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                bu.debug("Adding dynamic request header {}:{}", entry.getKey(), entry.getValue());
                httpRequestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        });
        if (httpProxyConfig.I()) {
            this.a(httpProxyConfig, uRI, httpRequestBuilder);
        }
        httpRequestBuilder.entity(this.a(httpRequestBuilder, typedValue, exclusiveHttpHeaders, string, httpSendBodyMode, httpStreamingType, transformationService));
        return httpRequestBuilder.build();
    }

    private void a(HttpProxyConfig httpProxyConfig, URI uRI, HttpRequestBuilder httpRequestBuilder) {
        try {
            List<String> list = httpProxyConfig.D().get(httpRequestBuilder.getUri(), Collections.emptyMap()).get("Cookie");
            if (list != null && list.size() > 0) {
                int n = bC.length() * (list.size() - 1);
                for (String string : list) {
                    n += string.length();
                }
                StringBuilder stringBuilder = new StringBuilder(n).append(list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    stringBuilder.append(bC).append(list.get(i));
                }
                httpRequestBuilder.addHeader(bB, stringBuilder.toString());
            }
        }
        catch (IOException iOException) {
            bu.warn("Error reading cookies for URI " + uRI, (Throwable)iOException);
        }
    }

    private void a(HttpProxyConfig httpProxyConfig, HttpResponse httpResponse, URI uRI) {
        Collection collection = httpResponse.getHeaderValues("Set-Cookie");
        Collection collection2 = httpResponse.getHeaderValues("Set-Cookie2");
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (collection != null) {
            hashMap.put("Set-Cookie", new ArrayList(collection));
        }
        if (collection2 != null) {
            hashMap.put("Set-Cookie2", new ArrayList(collection2));
        }
        try {
            httpProxyConfig.D().put(uRI, hashMap);
        }
        catch (IOException iOException) {
            bu.warn("Error storing cookies for URI " + uRI, (Throwable)iOException);
        }
    }

    HttpEntity a(HttpRequestBuilder httpRequestBuilder, TypedValue<?> typedValue, ExclusiveHttpHeaders exclusiveHttpHeaders, String string, HttpSendBodyMode httpSendBodyMode, HttpStreamingType httpStreamingType, TransformationService transformationService) throws IOException {
        Object object;
        Object object2;
        Object object3;
        TypedValue typedValue2 = typedValue;
        if (typedValue.getValue() instanceof CursorStream) {
            object3 = (CursorStream)typedValue.getValue();
            long l = object3.getPosition();
            object2 = (CursorStreamProvider)object3.getProvider();
            typedValue2 = l == 0L ? new TypedValue(object2, typedValue.getDataType(), typedValue.getByteLength()) : new TypedValue((Object)new OffsetCursorProviderWrapper((CursorStreamProvider)object2, l), typedValue.getDataType(), typedValue.getByteLength());
        }
        object3 = typedValue2.getValue();
        OptionalLong optionalLong = typedValue2.getByteLength();
        Optional<String> optional = exclusiveHttpHeaders.V().stream().filter(httpHeader -> httpHeader.getValue() != null && httpHeader.getKey().equalsIgnoreCase("Transfer-Encoding".toLowerCase())).map(httpHeader -> httpHeader.getValue()).findFirst();
        object2 = exclusiveHttpHeaders.V().stream().filter(httpHeader -> httpHeader.getValue() != null && httpHeader.getKey().equalsIgnoreCase("Content-Length".toLowerCase())).map(httpHeader -> httpHeader.getValue()).findFirst();
        Optional<String> optional2 = exclusiveHttpHeaders.V().stream().filter(httpHeader -> httpHeader.getValue() != null && httpHeader.getKey().equalsIgnoreCase("Content-Type".toLowerCase())).map(httpHeader -> httpHeader.getValue()).findFirst();
        boolean bl = this.a(object3, string, httpSendBodyMode);
        MediaType mediaType = typedValue2.getDataType().getMediaType();
        if (!(optional2.isPresent() || bl || MediaType.ANY.matches(mediaType))) {
            httpRequestBuilder.addHeader("Content-Type".toLowerCase(), mediaType.toRfcString());
        }
        if (bl) {
            object = new EmptyHttpEntity();
        } else if (object3 instanceof CursorStreamProvider) {
            if (httpStreamingType == HttpStreamingType.ALWAYS) {
                object = this.a(httpRequestBuilder, optional, (Optional<String>)object2, (CursorStreamProvider)object3);
            } else if (httpStreamingType == HttpStreamingType.AUTO) {
                if (((Optional)object2).isPresent()) {
                    this.a(httpRequestBuilder, optional, by);
                    object = new ByteArrayHttpEntity(this.a(((CursorStreamProvider)object3).openCursor(), transformationService));
                } else if (optional.isPresent() && "chunked".equalsIgnoreCase(optional.get()) || !optionalLong.isPresent()) {
                    object = new a((CursorStreamProvider)object3);
                } else {
                    this.a(httpRequestBuilder, optional, bA);
                    object = this.a(httpRequestBuilder, (CursorStreamProvider)object3, optionalLong);
                }
            } else {
                this.a(httpRequestBuilder, optional, bz);
                object = optionalLong.isPresent() ? this.a(httpRequestBuilder, (CursorStreamProvider)object3, optionalLong) : new ByteArrayHttpEntity(this.a(((CursorStreamProvider)object3).openCursor(), transformationService));
            }
        } else if (object3 instanceof InputStream) {
            if (httpStreamingType == HttpStreamingType.ALWAYS) {
                object = this.a(httpRequestBuilder, optional, (Optional<String>)object2, (InputStream)object3);
            } else if (httpStreamingType == HttpStreamingType.AUTO) {
                if (((Optional)object2).isPresent()) {
                    this.a(httpRequestBuilder, optional, by);
                    object = new ByteArrayHttpEntity(this.a(object3, transformationService));
                } else if (optional.isPresent() && "chunked".equalsIgnoreCase(optional.get()) || !optionalLong.isPresent()) {
                    object = new InputStreamHttpEntity((InputStream)object3);
                } else {
                    this.a(httpRequestBuilder, optional, bA);
                    object = this.a(httpRequestBuilder, (InputStream)object3, optionalLong);
                }
            } else {
                this.a(httpRequestBuilder, optional, bz);
                object = optionalLong.isPresent() ? this.a(httpRequestBuilder, (InputStream)object3, optionalLong) : new ByteArrayHttpEntity(this.a(object3, transformationService));
            }
        } else {
            byte[] byArray = this.a(object3, transformationService);
            if (httpStreamingType == HttpStreamingType.ALWAYS) {
                object = this.a(httpRequestBuilder, optional, (Optional<String>)object2, new ByteArrayInputStream(byArray));
            } else if (httpStreamingType == HttpStreamingType.NEVER) {
                this.a(httpRequestBuilder, optional, bz);
                object = new ByteArrayHttpEntity(byArray);
            } else {
                if (((Optional)object2).isPresent() && optional.isPresent()) {
                    this.a(httpRequestBuilder, optional, by);
                }
                object = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(byArray), (long)byArray.length);
            }
        }
        return object;
    }

    private boolean a(Object object, String string, HttpSendBodyMode httpSendBodyMode) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = object != null && !object.equals("");
        if (!bl2) {
            bl = true;
        } else {
            bl = bx.contains(string);
            if (httpSendBodyMode != HttpSendBodyMode.AUTO) {
                bl = httpSendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return bl;
    }

    private byte[] a(Object object, TransformationService transformationService) {
        return (byte[])transformationService.transform(Message.of((Object)object), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, Optional<String> optional2, CursorStreamProvider cursorStreamProvider) {
        this.a(httpRequestBuilder, optional, optional2);
        return new a(cursorStreamProvider);
    }

    private void a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, Optional<String> optional2) {
        if (optional2 != null) {
            httpRequestBuilder.removeHeader("Content-Length");
            if (bu.isDebugEnabled()) {
                bu.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS.");
            }
        }
        if (optional.isPresent() && !optional.get().equalsIgnoreCase("chunked")) {
            httpRequestBuilder.removeHeader("Transfer-Encoding");
            if (bu.isDebugEnabled()) {
                bu.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is ALWAYS", optional);
            }
        }
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, Optional<String> optional2, InputStream inputStream) {
        this.a(httpRequestBuilder, optional, optional2);
        return new InputStreamHttpEntity(inputStream);
    }

    private void a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, String string) {
        if (optional.isPresent()) {
            httpRequestBuilder.removeHeader("Transfer-Encoding");
            if (bu.isDebugEnabled()) {
                bu.debug(string);
            }
        }
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, InputStream inputStream, OptionalLong optionalLong) {
        httpRequestBuilder.addHeader("Content-Length", String.valueOf(optionalLong.getAsLong()));
        return new InputStreamHttpEntity(inputStream, optionalLong.getAsLong());
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, CursorStreamProvider cursorStreamProvider, OptionalLong optionalLong) {
        httpRequestBuilder.addHeader("Content-Length", String.valueOf(optionalLong.getAsLong()));
        return new a(cursorStreamProvider, optionalLong.getAsLong());
    }

    private void a(Throwable throwable, UriParameters uriParameters) {
        if ("HTTPS".equals(uriParameters.f()) && StringUtils.containsIgnoreCase((CharSequence)throwable.getMessage(), (CharSequence)"Remotely closed")) {
            bu.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    private Supplier<Object> a(StreamingHelper streamingHelper, HttpEntity httpEntity) {
        if (streamingHelper == null) {
            return () -> ((HttpEntity)httpEntity).getContent();
        }
        Object object = streamingHelper.resolveCursorProvider((Object)httpEntity.getContent());
        if (object instanceof CursorProvider) {
            return () -> ((CursorProvider)((CursorProvider)object)).openCursor();
        }
        return () -> object;
    }

    private HttpAuthentication a(HttpRequestAuthentication httpRequestAuthentication) {
        HttpRequestAuthentication httpRequestAuthentication2 = null;
        if (httpRequestAuthentication instanceof HttpAuthentication) {
            httpRequestAuthentication2 = httpRequestAuthentication;
        }
        return httpRequestAuthentication2;
    }

    URI a(HttpRequestParameter httpRequestParameter, HttpRequestAttributes httpRequestAttributes) throws URISyntaxException {
        URI uRI = new URI(httpRequestParameter.getAddress());
        if (uRI.getPort() == -1) {
            uRI = this.a(uRI) ? new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), 443, uRI.getPath(), uRI.getQuery(), uRI.getFragment()) : new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), 80, uRI.getPath(), uRI.getQuery(), uRI.getFragment());
        }
        return uRI;
    }

    private boolean a(URI uRI) {
        return "https".equalsIgnoreCase(uRI.getScheme());
    }

    private KeyStoreMappingHolder b(String string, HttpProxyConfig httpProxyConfig) {
        return httpProxyConfig.z().stream().filter(keyStoreMappingHolder -> keyStoreMappingHolder.k(string)).findFirst().orElse(null);
    }

    HttpClientConfiguration a(HttpProxyConfig httpProxyConfig, HttpRequestParameter httpRequestParameter, String string) throws CreateException, KeyStoreException {
        String string2 = String.format(bw, httpProxyConfig.getConfigName());
        ViaHttpProxyConfig viaHttpProxyConfig = httpProxyConfig.P();
        if (viaHttpProxyConfig != null && bu.isDebugEnabled()) {
            bu.debug("Proxy settings: {}:{}", (Object)viaHttpProxyConfig.getHost(), (Object)viaHttpProxyConfig.getPort());
        }
        cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties tcpClientSocketProperties = httpProxyConfig.H();
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.b(httpProxyConfig, string)).setProxyConfig((ProxyConfig)viaHttpProxyConfig).setClientSocketProperties(this.a(tcpClientSocketProperties)).setMaxConnections(httpProxyConfig.C().intValue()).setUsePersistentConnections(httpProxyConfig.B()).setConnectionIdleTimeout(httpProxyConfig.B() ? httpProxyConfig.F() : 0).setStreaming(httpProxyConfig.M()).setResponseBufferSize(httpProxyConfig.N()).setName(string2).build();
        return httpClientConfiguration;
    }

    private TlsContextFactory b(HttpProxyConfig httpProxyConfig, String string2) throws CreateException, KeyStoreException {
        TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();
        if (httpProxyConfig.L()) {
            bu.debug("Setting trust to all certificates");
            tlsContextFactoryBuilder.insecureTrustStore(true);
        } else if (httpProxyConfig.y() != null) {
            bu.debug("Adding trust store to SSL context.");
            tlsContextFactoryBuilder.insecureTrustStore(false).trustStoreType(httpProxyConfig.y().af().getType()).enabledProtocols(httpProxyConfig.K()).trustStorePath(httpProxyConfig.y().ah().toString());
            if (httpProxyConfig.A().getPassword() != null) {
                tlsContextFactoryBuilder.trustStorePassword(httpProxyConfig.A().getPassword());
            }
        }
        KeyStoreMappingHolder keyStoreMappingHolder = this.b(string2, httpProxyConfig);
        bu.debug("Found client keystore {} for request path: {}", (Object)keyStoreMappingHolder, (Object)string2);
        if (keyStoreMappingHolder != null) {
            Enumeration<String> enumeration;
            bu.debug("Adding client certificate to SSL context.");
            if (bu.isDebugEnabled()) {
                enumeration = keyStoreMappingHolder.af().aliases();
                bu.debug("Available keystore aliases: {}", (Object)StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<String>(){

                    public String U() {
                        return (String)enumeration.nextElement();
                    }

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.U();
                    }
                }, 16), false).collect(Collectors.joining(",")));
            }
            enumeration = keyStoreMappingHolder.af().aliases();
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<String>(){

                public String U() {
                    return (String)enumeration.nextElement();
                }

                @Override
                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.U();
                }
            }, 16), false).filter(string -> string.equals(keyStoreMappingHolder.c())).findFirst().orElseThrow(() -> new IllegalArgumentException(""));
            tlsContextFactoryBuilder.keyStoreType(keyStoreMappingHolder.af().getType()).keyStorePath(keyStoreMappingHolder.ah().toString()).enabledProtocols(httpProxyConfig.K()).keyAlias(keyStoreMappingHolder.c());
            if (keyStoreMappingHolder.getPassword() != null) {
                tlsContextFactoryBuilder.keyStorePassword(keyStoreMappingHolder.getPassword());
            } else {
                bu.warn("Setting empty store password. You should check if this is really intended!");
                tlsContextFactoryBuilder.keyStorePassword("");
            }
            if (keyStoreMappingHolder.d() != null) {
                tlsContextFactoryBuilder.keyPassword(keyStoreMappingHolder.d());
            } else {
                bu.warn("Setting empty key password. You should check if this is really intended!");
                tlsContextFactoryBuilder.keyPassword("");
            }
        }
        return tlsContextFactoryBuilder.build();
    }

    private TcpClientSocketProperties a(cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties tcpClientSocketProperties) {
        return TcpClientSocketProperties.builder().sendBufferSize(tcpClientSocketProperties.h()).receiveBufferSize(tcpClientSocketProperties.i()).clientTimeout(tcpClientSocketProperties.j()).connectionTimeout(tcpClientSocketProperties.p()).keepAlive(Boolean.valueOf(tcpClientSocketProperties.n())).linger(tcpClientSocketProperties.m()).sendTcpNoDelay(Boolean.valueOf(tcpClientSocketProperties.l())).build();
    }

    private class a
    implements HttpEntity {
        private Long bH;
        private final CursorStreamProvider bI;

        a(CursorStreamProvider cursorStreamProvider) {
            Objects.requireNonNull(cursorStreamProvider, "HTTP entity stream provider cannot be null.");
            this.bI = cursorStreamProvider;
        }

        a(CursorStreamProvider cursorStreamProvider, Long l) {
            this(cursorStreamProvider);
            this.bH = l;
        }

        public boolean isStreaming() {
            return true;
        }

        public boolean isComposed() {
            return false;
        }

        public InputStream getContent() {
            return (InputStream)this.bI.openCursor();
        }

        public byte[] getBytes() {
            return IOUtils.toByteArray((InputStream)this.getContent());
        }

        public Collection<HttpPart> getParts() {
            return Collections.emptyList();
        }

        public Optional<Long> getLength() {
            return Optional.ofNullable(this.bH);
        }
    }
}

