/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.tcp.config;

import cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties;
import cz.integsoft.mule.ipm.internal.socket.tcp.operation.TcpProxyOperation;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={TcpProxyOperation.class})
@Configuration(name="tcp-proxy-config")
public class TcpProxyConfig
implements Disposable,
Initialisable,
Startable,
Stoppable {
    private static final int CONNECTION_BOUND_THREADS_NUMBER = 3;
    private static final int THREAD_POOL_SHUTDOWN_TIMEOUT = 5;
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpProxyConfig.class);
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    private Scheduler scheduler;
    @Parameter
    @Optional
    @Placement(tab="TLS")
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="tcp-client-socket-properties")
    private TcpClientSocketProperties tcpClientSocketProperties;
    @Parameter
    @Optional
    @Placement(tab="Local Address Settings")
    @Alias(value="local-address")
    private final SocketConnectionSettings localAddressSettings = new SocketConnectionSettings();
    @Parameter
    @Optional
    @Summary(value="Sets max threads at once. Keeping connections open may result in MULE:OVERLOAD errors.")
    @Placement(tab="Advanced")
    @Alias(value="max-connections")
    private final int maxConnections = 50;
    @RefName
    private String configName;

    public void initialise() throws InitialisationException {
        LOGGER.info("Initializing config with name " + this.configName);
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        LOGGER.info("Initializing config with name " + this.configName + " done");
    }

    public void dispose() {
    }

    public void start() throws MuleException {
        LOGGER.debug("Startting...scheduler service {} with config {} and name {}", new Object[]{this.schedulerService, this.schedulerConfig, this.configName});
        this.scheduler = this.schedulerService.customScheduler(this.schedulerConfig.withMaxConcurrentTasks(150).withName("tcp-proxy-operation-" + this.configName).withWaitAllowed(true).withShutdownTimeout(5L, TimeUnit.SECONDS));
        LOGGER.debug("Scheduler has been initialized: {}", (Object)this.scheduler);
    }

    public void stop() throws MuleException {
        if (this.scheduler != null) {
            LOGGER.debug("Stopping scheduler...");
            this.scheduler.stop();
        }
    }

    public String getConfigName() {
        return this.configName;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public TcpClientSocketProperties getTcpClientSocketProperties() {
        return this.tcpClientSocketProperties;
    }

    public SocketConnectionSettings getLocalAddressSettings() {
        return this.localAddressSettings;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int getMaxConnections() {
        return 50;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TcpProxyConfig [tlsContext=");
        stringBuilder.append(this.tlsContext);
        stringBuilder.append(", tcpClientSocketProperties=");
        stringBuilder.append(this.tcpClientSocketProperties);
        stringBuilder.append(", localAddressSettings=");
        stringBuilder.append(this.localAddressSettings);
        stringBuilder.append(", maxConnections=");
        stringBuilder.append(50);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

