/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.tcp.operation;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.exception.ConnectionException;
import cz.integsoft.mule.ipm.api.exception.MaxConnectionsExhaustedException;
import cz.integsoft.mule.ipm.api.exception.ProcessingException;
import cz.integsoft.mule.ipm.api.tcp.InboundSocketWrapper;
import cz.integsoft.mule.ipm.api.tcp.OutboundSocketWrapper;
import cz.integsoft.mule.ipm.internal.AbstractOperation;
import cz.integsoft.mule.ipm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.ipm.internal.factory.SocketFactory;
import cz.integsoft.mule.ipm.internal.factory.SslSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.TcpSocketFactory;
import cz.integsoft.mule.ipm.internal.socket.SocketProtocol;
import cz.integsoft.mule.ipm.internal.socket.SocketUtils;
import cz.integsoft.mule.ipm.internal.socket.tcp.config.TcpProxyConfig;
import cz.integsoft.mule.ipm.internal.socket.tcp.parameter.TcpSocketRequestParameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.concurrent.Future;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpProxyOperation
extends AbstractOperation {
    private static final int ce = 1000;
    private static final SocketProtocol cf = SocketProtocol.tcp;
    private static final Logger cg = LoggerFactory.getLogger(TcpProxyOperation.class);

    @Throws(value={GenericErrorTypeProvider.class})
    @Alias(value="tcp-outbound-endpoint")
    @MediaType(value="*/*", strict=false)
    public Result<OutboundSocketWrapper, ImmutableSocketAttributes> a(@Config TcpProxyConfig tcpProxyConfig, @ParameterGroup(name="TCP request parameters") TcpSocketRequestParameter tcpSocketRequestParameter, @DefaultEncoding String string, @Content InboundSocketWrapper inboundSocketWrapper) {
        cg.debug("in TCP Proxy component: outboundUrl={}", (Object)tcpSocketRequestParameter.getAddress());
        this.s();
        try {
            URI uRI = new URI(tcpSocketRequestParameter.getAddress());
            if (!cf.name().equalsIgnoreCase(uRI.getScheme())) {
                throw new ProcessingException(ProxyErrorCode.IPM_ANY_006, "Wrong protocol specified! The operation accepts only TCP protocol, check address.");
            }
            final Socket socket = this.a(tcpProxyConfig, tcpSocketRequestParameter, uRI);
            cg.debug("Created a new outbound connection: {}", (Object)socket);
            OutboundSocketWrapper outboundSocketWrapper = new OutboundSocketWrapper(socket);
            ImmutableSocketAttributes immutableSocketAttributes = new ImmutableSocketAttributes(socket);
            final Socket socket2 = inboundSocketWrapper.getInboundSocket();
            cg.debug("Fetched inbound connection: {}", (Object)socket);
            tcpProxyConfig.getScheduler().execute((Runnable)new a(socket2, socket, tcpSocketRequestParameter.al()));
            if (!tcpSocketRequestParameter.ak()) {
                tcpProxyConfig.getScheduler().execute((Runnable)new a(socket, socket2, tcpSocketRequestParameter.al()));
            }
            Future future = tcpProxyConfig.getScheduler().submit(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        if (socket2.isClosed()) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    cg.info("Client socket ({}:{}) has been closed", (Object)socket2.getInetAddress().getHostName(), (Object)socket2.getPort());
                    TcpProxyOperation.this.a(socket);
                }
            });
            future.get();
            return Result.builder().output((Object)outboundSocketWrapper).attributes((Object)immutableSocketAttributes).build();
        }
        catch (MaxConnectionsExhaustedException maxConnectionsExhaustedException) {
            throw new ConnectionException(ProxyErrorCode.IPM_SND_004, "Maximum free connection reached while sending tcp request to " + tcpSocketRequestParameter.getAddress() + ": " + maxConnectionsExhaustedException.getLocalizedMessage(), (Throwable)((Object)maxConnectionsExhaustedException));
        }
        catch (Throwable throwable) {
            throw new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while sending tcp request to " + tcpSocketRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), throwable);
        }
    }

    private Socket a(TcpProxyConfig tcpProxyConfig, TcpSocketRequestParameter tcpSocketRequestParameter, URI uRI) {
        SocketFactory socketFactory = null;
        try {
            socketFactory = tcpProxyConfig.getTlsContext() != null ? new SslSocketFactory(tcpProxyConfig.getTlsContext()) : new TcpSocketFactory();
        }
        catch (Exception exception) {
            throw new MuleRuntimeException((Throwable)exception);
        }
        try {
            Socket socket = socketFactory.createSocket();
            SocketUtils.a(socket, tcpProxyConfig.getTcpClientSocketProperties());
            socket.bind(tcpProxyConfig.getLocalAddressSettings().getInetSocketAddress());
            socket.connect(this.a(tcpSocketRequestParameter, tcpProxyConfig.getTcpClientSocketProperties().o()), tcpProxyConfig.getTcpClientSocketProperties().p());
            return socket;
        }
        catch (Exception exception) {
            throw new ConnectionException(ProxyErrorCode.IPM_SND_005, "Connection problem occurred while sending tcp request to " + tcpSocketRequestParameter.getAddress() + ": " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private InetSocketAddress a(TcpSocketRequestParameter tcpSocketRequestParameter, boolean bl) throws ConnectionException {
        InetSocketAddress inetSocketAddress = tcpSocketRequestParameter.getInetSocketAddress();
        if (inetSocketAddress.isUnresolved() && bl) {
            throw new ConnectionException(ProxyErrorCode.IPM_SND_006, MessageFormat.format("Failed to resolve host from address {0}!", tcpSocketRequestParameter.getAddress()));
        }
        return inetSocketAddress;
    }

    private void a(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                cg.info("Closing remote host connection {}:{}", (Object)socket.getInetAddress().getHostName(), (Object)socket.getPort());
                socket.close();
            }
            catch (IOException iOException) {
                cg.warn("Failed to close outbound connection", (Throwable)iOException);
            }
        }
    }

    private static class a
    implements Runnable {
        private static final Logger ck = LoggerFactory.getLogger(a.class);
        private final Socket cl;
        private final Socket cm;
        private final int cn;

        a(Socket socket, Socket socket2, int n) {
            this.cl = socket;
            this.cm = socket2;
            this.cn = n;
        }

        @Override
        public void run() {
            ck.info("Proxy {}:{} --> {}:{}", new Object[]{this.cl.getInetAddress().getHostName(), this.cl.getPort(), this.cm.getInetAddress().getHostName(), this.cm.getPort()});
            try {
                int n;
                InputStream inputStream = this.an();
                OutputStream outputStream = this.ao();
                ck.debug("Input stream {} --> Output stream {}", (Object)inputStream, (Object)outputStream);
                if (inputStream == null || outputStream == null) {
                    return;
                }
                byte[] byArray = new byte[this.cn];
                while (-1 != (n = inputStream.read(byArray))) {
                    outputStream.write(byArray, 0, n);
                    ck.debug("Wrote {} bytes", (Object)n);
                    outputStream.flush();
                }
                ck.debug("The channel {} has finished.", (Object)this);
            }
            catch (SocketException socketException) {
            }
            catch (Exception exception) {
                throw new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while sending tcp data from " + this.cl.getInetAddress().getHostName() + ":" + this.cl.getPort() + " to " + this.cm.getInetAddress().getHostName() + ":" + this.cm.getPort() + " failed: " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                try {
                    this.cl.close();
                }
                catch (IOException iOException) {
                    ck.warn("Failed to close inbound connection.", (Throwable)iOException);
                }
            }
        }

        private InputStream an() {
            try {
                return new BufferedInputStream(this.cl.getInputStream());
            }
            catch (IOException iOException) {
                ck.warn("Failed to obtain stream from " + this.cl.toString(), (Throwable)iOException);
                return null;
            }
        }

        private OutputStream ao() {
            try {
                return new BufferedOutputStream(this.cm.getOutputStream());
            }
            catch (IOException iOException) {
                ck.warn("Failed to obtain stream from " + this.cm.toString(), (Throwable)iOException);
                return null;
            }
        }
    }
}

