/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.tcp.source;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.tcp.InboundSocketWrapper;
import cz.integsoft.mule.ipm.api.tcp.TcpServerSocketProperties;
import cz.integsoft.mule.ipm.internal.factory.ServerSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.SslServerSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.TcpServerSocketFactory;
import cz.integsoft.mule.ipm.internal.socket.SocketUtils;
import cz.integsoft.mule.ipm.internal.socket.tcp.config.TcpListenerConfig;
import cz.integsoft.mule.ipm.internal.socket.tcp.worker.TcpWorker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="tcp-proxy-listener")
@MediaType(value="*/*", strict=false)
public final class TcpSocketListener
extends Source<InboundSocketWrapper, ImmutableSocketAttributes>
implements Initialisable {
    private static final Logger co = LoggerFactory.getLogger(TcpSocketListener.class);
    @Inject
    private MuleContext aS;
    @Inject
    private SchedulerService schedulerService;
    private ServerSocket cp;
    @Config
    private TcpListenerConfig cq;
    private ComponentLocation cr;
    private final AtomicBoolean cs = new AtomicBoolean(false);
    private Scheduler ct;
    private Scheduler cu;
    private Future<?> cv;

    public void onStart(SourceCallback<InboundSocketWrapper, ImmutableSocketAttributes> sourceCallback) throws MuleException {
        co.debug("Starting TCP Listener...");
        this.cp = this.aq();
        this.ct = this.schedulerService.ioScheduler(this.aS.getSchedulerBaseConfig().withName(String.format("%s.ipm.socket.worker", this.cr.getRootContainerName())));
        this.cs.set(false);
        this.cu = this.schedulerService.customScheduler(this.aS.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(String.format("%s.ipm.socket.listener", this.cr.getRootContainerName())));
        this.cv = this.cu.submit(() -> this.a(sourceCallback, this.cp));
    }

    @OnSuccess
    public void onSuccess(SourceCallbackContext sourceCallbackContext) {
        sourceCallbackContext.getVariable("IPM_WORK").ifPresent(socketWorker -> socketWorker.a(sourceCallbackContext));
    }

    @OnError
    public void onError(Error error, SourceCallbackContext sourceCallbackContext) {
        sourceCallbackContext.getVariable("IPM_WORK").ifPresent(socketWorker -> socketWorker.b(error.getCause()));
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        Optional optional = sourceResult.getInvocationError();
        if (optional.isPresent()) {
            co.error("Error occurred in async", optional.get());
            this.cs.set(true);
        }
    }

    public void onStop() {
        co.debug("Stopping TCP Listener...");
        this.cs.set(true);
        if (this.cv != null) {
            this.cv.cancel(false);
        }
        if (this.cu != null) {
            this.cu.stop();
        }
        if (this.ct != null) {
            this.ct.stop();
        }
        if (this.cp != null) {
            try {
                this.cp.close();
            }
            catch (IOException iOException) {
                co.warn("Error closing server socket", (Throwable)iOException);
            }
        }
    }

    private boolean ap() {
        return this.cs.get() || Thread.currentThread().isInterrupted();
    }

    private void a(SourceCallback<InboundSocketWrapper, ImmutableSocketAttributes> sourceCallback, ServerSocket serverSocket) {
        co.debug("Starting listening on TCP port...");
        while (!this.ap()) {
            try {
                Socket socket = this.ar();
                co.debug("Listener is accepting connections... {}", (Object)socket);
                SocketUtils.a(socket, this.cq.getTcpServerSocketProperties());
                TcpWorker tcpWorker = new TcpWorker(socket, sourceCallback);
                tcpWorker.a((Exception exception) -> {
                    if (co.isDebugEnabled()) {
                        co.debug(String.format("Got exception '%s'. Work being executed was: %s", exception.getClass().getName(), tcpWorker.toString()));
                    }
                    ExceptionUtils.extractConnectionException((Throwable)exception).ifPresent(arg_0 -> ((SourceCallback)sourceCallback).onConnectionException(arg_0));
                });
                this.ct.execute((Runnable)tcpWorker);
                continue;
            }
            catch (cz.integsoft.mule.ipm.api.exception.ConnectionException connectionException) {
                if (this.ap()) continue;
                sourceCallback.onConnectionException(new ConnectionException((Throwable)((Object)connectionException)));
                continue;
            }
            catch (Exception exception2) {
                if (this.ap()) {
                    return;
                }
                if (!co.isDebugEnabled()) continue;
                co.debug("An exception occurred while listening for new connections", (Throwable)exception2);
                continue;
            }
            break;
        }
        return;
    }

    private ServerSocket aq() throws cz.integsoft.mule.ipm.api.exception.ConnectionException {
        ServerSocketFactory serverSocketFactory = null;
        try {
            serverSocketFactory = this.cq.getTlsContext() != null ? new SslServerSocketFactory(this.cq.getTlsContext()) : new TcpServerSocketFactory();
        }
        catch (Exception exception) {
            throw new MuleRuntimeException((Throwable)exception);
        }
        try {
            ServerSocket serverSocket = serverSocketFactory.createServerSocket();
            TcpServerSocketProperties tcpServerSocketProperties = this.cq.getTcpServerSocketProperties();
            if (tcpServerSocketProperties.i() != null) {
                serverSocket.setReceiveBufferSize(tcpServerSocketProperties.i());
            }
            if (tcpServerSocketProperties.q() != null) {
                serverSocket.setSoTimeout(tcpServerSocketProperties.q());
            }
            serverSocket.setReuseAddress(tcpServerSocketProperties.k());
            InetSocketAddress inetSocketAddress = this.a(this.cq, this.cq.getTcpServerSocketProperties().o());
            serverSocket.bind(inetSocketAddress, tcpServerSocketProperties.r());
            return serverSocket;
        }
        catch (Exception exception) {
            throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_002, "Could not create TCP listener socket", (Throwable)exception);
        }
    }

    private Socket ar() throws cz.integsoft.mule.ipm.api.exception.ConnectionException, IOException {
        try {
            return this.cp.accept();
        }
        catch (IOException iOException) {
            if (!this.cp.isClosed()) {
                throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_003, "An error occurred while listening for new TCP connections", (Throwable)iOException);
            }
            co.debug("TCP listener socket has been gracefully closed");
            throw iOException;
        }
    }

    private InetSocketAddress a(TcpListenerConfig tcpListenerConfig, boolean bl) throws cz.integsoft.mule.ipm.api.exception.ConnectionException {
        InetSocketAddress inetSocketAddress = tcpListenerConfig.getInetSocketAddress();
        if (inetSocketAddress.isUnresolved() && bl) {
            throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_001, MessageFormat.format("Failed to resolve host {0}!", tcpListenerConfig.getHost()));
        }
        return inetSocketAddress;
    }

    public void initialise() throws InitialisationException {
        if (this.cq.getTlsContext() != null && !this.cq.getTlsContext().isKeyStoreConfigured()) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.cq.getTlsContext());
    }
}

