/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.api.failover.strategy;

import cz.integsoft.mule.ipm.api.failover.FailoverHost;
import cz.integsoft.mule.ipm.api.failover.FailoverTestingStrategy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="ping")
public class PingTestingStrategy
implements FailoverTestingStrategy<FailoverHost> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTestingStrategy.class);
    @Parameter
    @Optional(defaultValue="1000")
    @Summary(value="Timeout in milliseconds to reach the host. Optional and default is 1000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="timeout")
    private int timeout;

    public PingTestingStrategy() {
    }

    public PingTestingStrategy(int n) {
        this.timeout = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAvailable(FailoverHost failoverHost) {
        if (failoverHost == null) {
            return false;
        }
        try (Socket socket = new Socket();){
            LOGGER.debug("Testing host {}", (Object)failoverHost);
            socket.connect(new InetSocketAddress(failoverHost.getHostname(), failoverHost.getPort()), this.timeout);
            LOGGER.debug("Host {} is up!", (Object)failoverHost);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            LOGGER.debug(MessageFormat.format("Got exception in testing strategy for host {0}: {1}", failoverHost, exception.getLocalizedMessage()));
            return false;
        }
    }
}

