/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.failover.config;

import cz.integsoft.mule.ipm.api.failover.FailoverHost;
import cz.integsoft.mule.ipm.api.failover.FailoverManager;
import cz.integsoft.mule.ipm.internal.failover.operation.GetFailoverHostOperation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={GetFailoverHostOperation.class})
@Configuration(name="failover-config")
public class FailoverConfig
implements Disposable,
Initialisable,
Startable,
Stoppable {
    private static final Logger ag = LoggerFactory.getLogger(FailoverConfig.class);
    @RefName
    private String configName;
    @Parameter
    @Summary(value="Defined failover manager to use")
    @Alias(value="failover-manager")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private FailoverManager<FailoverHost> failoverManager;

    public void initialise() throws InitialisationException {
        ag.info("Initializing config with name " + this.configName);
        ag.info("Initializing config with name " + this.configName + " done");
    }

    public void dispose() {
        try {
            this.failoverManager.close();
        }
        catch (Exception exception) {
            ag.warn("Failed to close failover manager", (Throwable)exception);
        }
    }

    public String getConfigName() {
        return this.configName;
    }

    public FailoverManager<FailoverHost> getFailoverManager() {
        return this.failoverManager;
    }

    public void stop() throws MuleException {
        this.failoverManager.stop();
    }

    public void start() throws MuleException {
        this.failoverManager.start();
    }
}

