/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.failover.operation;

import cz.integsoft.mule.ipm.api.failover.FailoverHost;
import cz.integsoft.mule.ipm.internal.AbstractOperation;
import cz.integsoft.mule.ipm.internal.error.FailoverErrorTypeProvider;
import cz.integsoft.mule.ipm.internal.failover.config.FailoverConfig;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFailoverHostOperation
extends AbstractOperation {
    private static final Logger ar = LoggerFactory.getLogger(GetFailoverHostOperation.class);

    @Throws(value={FailoverErrorTypeProvider.class})
    @Alias(value="get-failover-host")
    @MediaType(value="*/*", strict=false)
    public void a(@Config FailoverConfig failoverConfig, @Optional(defaultValue="false") @Alias(value="ignore-exceptions") @Summary(value="Sets if the operation should ignore exceptions. Optional and default is false.") boolean bl, CompletionCallback<FailoverHost, Void> completionCallback) {
        this.s();
        try {
            FailoverHost failoverHost = failoverConfig.getFailoverManager().getFirst();
            ar.debug("Getting host: {}", (Object)failoverHost);
            completionCallback.success(Result.builder().output((Object)failoverHost).build());
        }
        catch (Exception exception) {
            if (bl) {
                ar.warn("Error during getting failover host occurred: " + exception.getLocalizedMessage(), (Throwable)exception);
                completionCallback.success(Result.builder().build());
            }
            ar.error("Error during getting failover host occurred: " + exception.getLocalizedMessage(), (Throwable)exception);
            completionCallback.error((Throwable)exception);
        }
    }
}

