/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.tcp.source;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.tcp.InboundSocketWrapper;
import cz.integsoft.mule.ipm.api.tcp.TcpServerSocketProperties;
import cz.integsoft.mule.ipm.internal.factory.ServerSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.SslServerSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.TcpServerSocketFactory;
import cz.integsoft.mule.ipm.internal.socket.SocketUtils;
import cz.integsoft.mule.ipm.internal.socket.tcp.config.TcpListenerConfig;
import cz.integsoft.mule.ipm.internal.socket.tcp.worker.TcpWorker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="tcp-proxy-listener")
@MediaType(value="*/*", strict=false)
public final class TcpSocketListener
extends Source<InboundSocketWrapper, ImmutableSocketAttributes>
implements Initialisable {
    private static final Logger cp = LoggerFactory.getLogger(TcpSocketListener.class);
    @Inject
    private MuleContext aT;
    @Inject
    private SchedulerService schedulerService;
    private ServerSocket cq;
    @Config
    private TcpListenerConfig cr;
    private ComponentLocation cs;
    private final AtomicBoolean ct = new AtomicBoolean(false);
    private Scheduler cu;
    private Scheduler cv;
    private Future<?> cw;

    public void onStart(SourceCallback<InboundSocketWrapper, ImmutableSocketAttributes> sourceCallback) throws MuleException {
        cp.debug("Starting TCP Listener...");
        this.cq = this.ar();
        this.cu = this.schedulerService.ioScheduler(this.aT.getSchedulerBaseConfig().withName(String.format("%s.ipm.socket.worker", this.cs.getRootContainerName())));
        this.ct.set(false);
        this.cv = this.schedulerService.customScheduler(this.aT.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(String.format("%s.ipm.socket.listener", this.cs.getRootContainerName())));
        this.cw = this.cv.submit(() -> this.a(sourceCallback, this.cq));
    }

    @OnSuccess
    public void onSuccess(SourceCallbackContext sourceCallbackContext) {
        sourceCallbackContext.getVariable("IPM_WORK").ifPresent(socketWorker -> socketWorker.a(sourceCallbackContext));
    }

    @OnError
    public void onError(Error error, SourceCallbackContext sourceCallbackContext) {
        sourceCallbackContext.getVariable("IPM_WORK").ifPresent(socketWorker -> socketWorker.b(error.getCause()));
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        Optional optional = sourceResult.getInvocationError();
        if (optional.isPresent()) {
            cp.error("Error occurred in async", optional.get());
            this.ct.set(true);
        }
    }

    public void onStop() {
        cp.debug("Stopping TCP Listener...");
        this.ct.set(true);
        if (this.cw != null) {
            this.cw.cancel(false);
        }
        if (this.cv != null) {
            this.cv.stop();
        }
        if (this.cu != null) {
            this.cu.stop();
        }
        if (this.cq != null) {
            try {
                this.cq.close();
            }
            catch (IOException iOException) {
                cp.warn("Error closing server socket", (Throwable)iOException);
            }
        }
    }

    private boolean aq() {
        return this.ct.get() || Thread.currentThread().isInterrupted();
    }

    private void a(SourceCallback<InboundSocketWrapper, ImmutableSocketAttributes> sourceCallback, ServerSocket serverSocket) {
        cp.debug("Starting listening on TCP port...");
        while (!this.aq()) {
            try {
                Socket socket = this.as();
                cp.debug("Listener is accepting connections... {}", (Object)socket);
                SocketUtils.a(socket, this.cr.getTcpServerSocketProperties());
                TcpWorker tcpWorker = new TcpWorker(socket, sourceCallback);
                tcpWorker.a((Exception exception) -> {
                    if (cp.isDebugEnabled()) {
                        cp.debug(String.format("Got exception '%s'. Work being executed was: %s", exception.getClass().getName(), tcpWorker.toString()));
                    }
                    ExceptionUtils.extractConnectionException((Throwable)exception).ifPresent(arg_0 -> ((SourceCallback)sourceCallback).onConnectionException(arg_0));
                });
                this.cu.execute((Runnable)tcpWorker);
                continue;
            }
            catch (cz.integsoft.mule.ipm.api.exception.ConnectionException connectionException) {
                if (this.aq()) continue;
                sourceCallback.onConnectionException(new ConnectionException((Throwable)((Object)connectionException)));
                continue;
            }
            catch (Exception exception2) {
                if (this.aq()) {
                    return;
                }
                if (!cp.isDebugEnabled()) continue;
                cp.debug("An exception occurred while listening for new connections", (Throwable)exception2);
                continue;
            }
            break;
        }
        return;
    }

    private ServerSocket ar() throws cz.integsoft.mule.ipm.api.exception.ConnectionException {
        ServerSocketFactory serverSocketFactory = null;
        try {
            serverSocketFactory = this.cr.getTlsContext() != null ? new SslServerSocketFactory(this.cr.getTlsContext()) : new TcpServerSocketFactory();
        }
        catch (Exception exception) {
            throw new MuleRuntimeException((Throwable)exception);
        }
        try {
            ServerSocket serverSocket = serverSocketFactory.createServerSocket();
            TcpServerSocketProperties tcpServerSocketProperties = this.cr.getTcpServerSocketProperties();
            if (tcpServerSocketProperties.i() != null) {
                serverSocket.setReceiveBufferSize(tcpServerSocketProperties.i());
            }
            if (tcpServerSocketProperties.q() != null) {
                serverSocket.setSoTimeout(tcpServerSocketProperties.q());
            }
            serverSocket.setReuseAddress(tcpServerSocketProperties.k());
            InetSocketAddress inetSocketAddress = this.a(this.cr, this.cr.getTcpServerSocketProperties().o());
            serverSocket.bind(inetSocketAddress, tcpServerSocketProperties.r());
            return serverSocket;
        }
        catch (Exception exception) {
            throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_002, "Could not create TCP listener socket", (Throwable)exception);
        }
    }

    private Socket as() throws cz.integsoft.mule.ipm.api.exception.ConnectionException, IOException {
        try {
            return this.cq.accept();
        }
        catch (IOException iOException) {
            if (!this.cq.isClosed()) {
                throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_003, "An error occurred while listening for new TCP connections", (Throwable)iOException);
            }
            cp.debug("TCP listener socket has been gracefully closed");
            throw iOException;
        }
    }

    private InetSocketAddress a(TcpListenerConfig tcpListenerConfig, boolean bl) throws cz.integsoft.mule.ipm.api.exception.ConnectionException {
        InetSocketAddress inetSocketAddress = tcpListenerConfig.getInetSocketAddress();
        if (inetSocketAddress.isUnresolved() && bl) {
            throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_001, MessageFormat.format("Failed to resolve host {0}!", tcpListenerConfig.getHost()));
        }
        return inetSocketAddress;
    }

    public void initialise() throws InitialisationException {
        if (this.cr.getTlsContext() != null && !this.cr.getTlsContext().isKeyStoreConfigured()) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.cr.getTlsContext());
    }
}

