/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http.config;

import cz.integsoft.mule.ipm.api.http.authentication.HttpRequestAuthentication;
import cz.integsoft.mule.ipm.api.http.parameter.ClientKeystore;
import cz.integsoft.mule.ipm.api.http.parameter.HttpHeader;
import cz.integsoft.mule.ipm.api.http.parameter.ServerKeystore;
import cz.integsoft.mule.ipm.api.http.proxy.ViaHttpProxyConfig;
import cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties;
import cz.integsoft.mule.ipm.internal.http.HttpClientConnectionManager;
import cz.integsoft.mule.ipm.internal.http.operation.HttpProxyOperation;
import cz.integsoft.mule.ipm.internal.http.parameter.KeyStoreHolder;
import cz.integsoft.mule.ipm.internal.http.parameter.KeyStoreMappingHolder;
import cz.integsoft.mule.ipm.internal.http.parameter.SslProtocolValueProvider;
import java.net.CookieManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={HttpProxyOperation.class})
@Configuration(name="http-proxy-config")
@ExternalLibs(value={@ExternalLib(name="Spring Core", coordinates="org.springframework:spring-core:[5.1.0.RELEASE,)", type=ExternalLibraryType.DEPENDENCY)})
@Import(type=HttpResponseAttributes.class)
public class HttpProxyConfig
implements Initialisable {
    private static final Logger aM = LoggerFactory.getLogger(HttpProxyConfig.class);
    private static final String aN = "-1";
    @Deprecated
    private static final String aO = "10";
    private static final String aP = "30000";
    private static final String aQ = "-1";
    private static final String aR = "-1";
    @RefName
    private String configName;
    @Inject
    private HttpClientConnectionManager aS;
    @Inject
    private MuleContext aT;
    private CookieManager aU;
    @Parameter
    @Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    @Alias(value="via-proxy")
    private ViaHttpProxyConfig aV;
    @Parameter
    @Optional
    @Placement(tab="TLS")
    @Alias(value="authentication")
    private HttpRequestAuthentication aD;
    @Parameter
    @Optional
    @Alias(value="server-keystore")
    private ServerKeystore aW;
    @Parameter
    @Optional
    @Alias(value="client-keystores")
    private final List<ClientKeystore> aX = Collections.emptyList();
    private KeyStoreHolder aY;
    private List<KeyStoreMappingHolder> aZ;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=1)
    @Alias(value="max-connections")
    private Integer ba;
    @Parameter
    @Optional(defaultValue="10")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=2)
    @Alias(value="max-connections-per-route")
    @Summary(value="Deprecated, not used and has no effect.")
    @Deprecated
    private Integer bb;
    @Parameter
    @Optional(defaultValue="30000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=3)
    @Alias(value="connection-idle-timeout")
    private Integer bc;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=4)
    @Alias(value="connection-ttl")
    private Integer bd;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=5)
    @Alias(value="tcp-client-socket-properties")
    private TcpClientSocketProperties be;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    @Alias(value="enable-cookies")
    private boolean bf;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=7)
    @Alias(value="connection-request-timeout")
    private Integer bg;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=8)
    private boolean bh;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=9)
    @Alias(value="response-buffer-size")
    private int bi;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=10)
    @Alias(value="stream-response")
    private boolean bj;
    @Parameter
    @OfValues(value=SslProtocolValueProvider.class)
    @Optional(defaultValue="TLSv1.2")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="TLS", order=1)
    @Alias(value="ssl-protocol", description="Defines SSL protocol. One of these protocols is supported: SSLv3, TLSv1, TLSv1.1 and TLSv1.2. Default is TLSv1.2.")
    private String bk;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="TLS", order=2)
    @Alias(value="trust-all", description="Set to true to disable trust check on the SSL endpoint.")
    private boolean bl;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Connection")
    @Alias(value="follow-redirects")
    private boolean bm;
    @Parameter
    @Optional
    @NullSafe
    @Alias(value="default-http-headers")
    private List<HttpHeader> bn;

    public void initialise() throws InitialisationException {
        aM.info("Initializing config with name " + this.configName);
        aM.debug("Server keystore: {}", (Object)this.aW);
        if (this.aW != null) {
            aM.info("Initializing custom trust store {}", (Object)this.aW);
            this.aY = new KeyStoreHolder(this.aW.b(), this.aW.getPassword());
            this.aY.ag();
        }
        aM.info("Initializing server keystore done");
        aM.debug("Client keystores: {}", (Object)this.aX.stream().map(clientKeystore -> clientKeystore.toString()).collect(Collectors.joining("\n")));
        this.aZ = new LinkedList<KeyStoreMappingHolder>();
        this.aX.forEach(clientKeystore -> {
            KeyStoreMappingHolder keyStoreMappingHolder = new KeyStoreMappingHolder(clientKeystore.b(), clientKeystore.getPassword(), clientKeystore.d(), clientKeystore.c(), clientKeystore.e());
            keyStoreMappingHolder.ag();
            this.aZ.add(keyStoreMappingHolder);
        });
        if (this.J()) {
            this.aU = new CookieManager();
        }
        aM.info("Initializing client keystores done");
        aM.info("Initializing config with name " + this.configName + " done");
    }

    public String getConfigName() {
        return this.configName;
    }

    public KeyStoreHolder z() {
        return this.aY;
    }

    public List<KeyStoreMappingHolder> A() {
        return this.aZ;
    }

    public ServerKeystore B() {
        return this.aW;
    }

    public final boolean C() {
        return this.bh;
    }

    public Integer D() {
        return this.ba;
    }

    public final CookieManager E() {
        return this.aU;
    }

    public Integer F() {
        return this.bb;
    }

    public Integer G() {
        return this.bc;
    }

    public Integer H() {
        return this.bd;
    }

    public TcpClientSocketProperties I() {
        return this.be;
    }

    public boolean J() {
        return this.bf;
    }

    public boolean K() {
        return this.bm;
    }

    public String L() {
        return this.bk;
    }

    public boolean M() {
        return this.bl;
    }

    public final boolean N() {
        return this.bj;
    }

    public final int O() {
        return this.bi;
    }

    public final List<ClientKeystore> P() {
        return this.aX;
    }

    public ViaHttpProxyConfig Q() {
        return this.aV;
    }

    public HttpRequestAuthentication R() {
        return this.aD;
    }

    public List<HttpHeader> S() {
        return this.bn;
    }

    public final Integer T() {
        return this.bg;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpProxyConfig [configName=");
        stringBuilder.append(this.configName);
        stringBuilder.append(", viaProxyConfig=");
        stringBuilder.append(this.aV);
        stringBuilder.append(", serverKeystore=");
        stringBuilder.append(this.aW);
        stringBuilder.append(", clientKeystores=");
        stringBuilder.append(this.aX);
        stringBuilder.append(", trustStoreHolder=");
        stringBuilder.append(this.aY);
        stringBuilder.append(", clientKeystoreHolders=");
        stringBuilder.append(this.aZ);
        stringBuilder.append(", maxConnections=");
        stringBuilder.append(this.ba);
        stringBuilder.append(", maxConnectionsPerRoute=");
        stringBuilder.append(this.bb);
        stringBuilder.append(", connectionIdleTimeout=");
        stringBuilder.append(this.bc);
        stringBuilder.append(", connectionTimeToLive=");
        stringBuilder.append(this.bd);
        stringBuilder.append(", connectionRequestTimeout=");
        stringBuilder.append(this.bg);
        stringBuilder.append(", streamResponse=");
        stringBuilder.append(this.bj);
        stringBuilder.append(", clientSocketProperties=");
        stringBuilder.append(this.be);
        stringBuilder.append(", enableCookies=");
        stringBuilder.append(this.bf);
        stringBuilder.append(", sslProtocol=");
        stringBuilder.append(this.bk);
        stringBuilder.append(", trustAll=");
        stringBuilder.append(this.bl);
        stringBuilder.append(", followRedirects=");
        stringBuilder.append(this.bm);
        stringBuilder.append(", authentication=");
        stringBuilder.append(this.aD);
        stringBuilder.append(", responseBufferSize");
        stringBuilder.append(this.bi);
        stringBuilder.append(", usePersistentConnections");
        stringBuilder.append(this.bh);
        stringBuilder.append(", cookieManager");
        stringBuilder.append(this.aU);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

