/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.parameter;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class AbstractSocketRequestParameter {
    private static final int cf = 0;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Summary(value="Outbound address, e.g. tcp://host:port")
    @Alias(value="address", description="Outbound address. Can be expression.")
    private String bP;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Enables one-way (just) send data if true. Default is false.")
    @Alias(value="one-way", description="Boolean value")
    private boolean cg;
    @Parameter
    @Optional(defaultValue="8192")
    @Summary(value="Reading buffer size. Default is 8192 bytes.")
    @Alias(value="read-buffer-size")
    private int ch;

    public String getAddress() {
        return this.bP;
    }

    public boolean am() {
        return this.cg;
    }

    public int an() {
        return this.ch;
    }

    public InetSocketAddress getInetSocketAddress() {
        URI uRI;
        try {
            uRI = new URI(this.bP);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        int n = uRI.getPort();
        String string = uRI.getHost();
        if (StringUtils.isBlank((String)string) && n == -1) {
            return new InetSocketAddress(0);
        }
        if (n == -1 && !StringUtils.isBlank((String)string)) {
            return new InetSocketAddress(string, 0);
        }
        if (n > 0 && StringUtils.isBlank((String)string)) {
            return new InetSocketAddress(n);
        }
        return new InetSocketAddress(string, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AbstractSocketRequestParameter [address=");
        stringBuilder.append(this.bP);
        stringBuilder.append(", oneWay=");
        stringBuilder.append(this.cg);
        stringBuilder.append(", readBufferSize=");
        stringBuilder.append(this.ch);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

