/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.tcp.source;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.tcp.InboundSocketWrapper;
import cz.integsoft.mule.ipm.api.tcp.TcpServerSocketProperties;
import cz.integsoft.mule.ipm.internal.factory.ServerSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.SslServerSocketFactory;
import cz.integsoft.mule.ipm.internal.factory.TcpServerSocketFactory;
import cz.integsoft.mule.ipm.internal.socket.SocketUtils;
import cz.integsoft.mule.ipm.internal.socket.tcp.config.TcpListenerConfig;
import cz.integsoft.mule.ipm.internal.socket.tcp.worker.TcpWorker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.extension.socket.api.ImmutableSocketAttributes;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="tcp-proxy-listener")
@MediaType(value="*/*", strict=false)
public final class TcpSocketListener
extends Source<InboundSocketWrapper, ImmutableSocketAttributes>
implements Initialisable {
    private static final Logger cs = LoggerFactory.getLogger(TcpSocketListener.class);
    @Inject
    private MuleContext aT;
    @Inject
    private SchedulerService schedulerService;
    private ServerSocket ct;
    @Config
    private TcpListenerConfig cu;
    private ComponentLocation cv;
    private final AtomicBoolean cw = new AtomicBoolean(false);
    private Scheduler cx;
    private Scheduler cy;
    private Future<?> cz;

    public void onStart(SourceCallback<InboundSocketWrapper, ImmutableSocketAttributes> sourceCallback) throws MuleException {
        cs.debug("Starting TCP Listener...");
        this.ct = this.as();
        this.cx = this.schedulerService.ioScheduler(this.aT.getSchedulerBaseConfig().withName(String.format("%s.ipm.socket.worker", this.cv.getRootContainerName())));
        this.cw.set(false);
        this.cy = this.schedulerService.customScheduler(this.aT.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(String.format("%s.ipm.socket.listener", this.cv.getRootContainerName())));
        this.cz = this.cy.submit(() -> this.a(sourceCallback, this.ct));
    }

    @OnSuccess
    public void onSuccess(SourceCallbackContext sourceCallbackContext) {
        sourceCallbackContext.getVariable("IPM_WORK").ifPresent(socketWorker -> socketWorker.a(sourceCallbackContext));
    }

    @OnError
    public void onError(Error error, SourceCallbackContext sourceCallbackContext) {
        sourceCallbackContext.getVariable("IPM_WORK").ifPresent(socketWorker -> socketWorker.b(error.getCause()));
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        Optional optional = sourceResult.getInvocationError();
        if (optional.isPresent()) {
            cs.error("Error occurred in async", optional.get());
            this.cw.set(true);
        }
    }

    public void onStop() {
        cs.debug("Stopping TCP Listener...");
        this.cw.set(true);
        if (this.cz != null) {
            this.cz.cancel(false);
        }
        if (this.cy != null) {
            this.cy.stop();
        }
        if (this.cx != null) {
            this.cx.stop();
        }
        if (this.ct != null) {
            try {
                this.ct.close();
            }
            catch (IOException iOException) {
                cs.warn("Error closing server socket", (Throwable)iOException);
            }
        }
    }

    private boolean ar() {
        return this.cw.get() || Thread.currentThread().isInterrupted();
    }

    private void a(SourceCallback<InboundSocketWrapper, ImmutableSocketAttributes> sourceCallback, ServerSocket serverSocket) {
        cs.debug("Starting listening on TCP port...");
        while (!this.ar()) {
            try {
                Socket socket = this.at();
                cs.debug("Listener is accepting connections... {}", (Object)socket);
                SocketUtils.a(socket, this.cu.getTcpServerSocketProperties());
                TcpWorker tcpWorker = new TcpWorker(socket, sourceCallback);
                tcpWorker.a((Exception exception) -> {
                    if (cs.isDebugEnabled()) {
                        cs.debug(String.format("Got exception '%s'. Work being executed was: %s", exception.getClass().getName(), tcpWorker.toString()));
                    }
                    ExceptionUtils.extractConnectionException((Throwable)exception).ifPresent(arg_0 -> ((SourceCallback)sourceCallback).onConnectionException(arg_0));
                });
                this.cx.execute((Runnable)tcpWorker);
                continue;
            }
            catch (cz.integsoft.mule.ipm.api.exception.ConnectionException connectionException) {
                if (this.ar()) continue;
                sourceCallback.onConnectionException(new ConnectionException((Throwable)((Object)connectionException)));
                continue;
            }
            catch (Exception exception2) {
                if (this.ar()) {
                    return;
                }
                if (!cs.isDebugEnabled()) continue;
                cs.debug("An exception occurred while listening for new connections", (Throwable)exception2);
                continue;
            }
            break;
        }
        return;
    }

    private ServerSocket as() throws cz.integsoft.mule.ipm.api.exception.ConnectionException {
        ServerSocketFactory serverSocketFactory = null;
        try {
            serverSocketFactory = this.cu.getTlsContext() != null ? new SslServerSocketFactory(this.cu.getTlsContext()) : new TcpServerSocketFactory();
        }
        catch (Exception exception) {
            throw new MuleRuntimeException((Throwable)exception);
        }
        try {
            ServerSocket serverSocket = serverSocketFactory.createServerSocket();
            TcpServerSocketProperties tcpServerSocketProperties = this.cu.getTcpServerSocketProperties();
            if (tcpServerSocketProperties.i() != null) {
                serverSocket.setReceiveBufferSize(tcpServerSocketProperties.i());
            }
            if (tcpServerSocketProperties.q() != null) {
                serverSocket.setSoTimeout(tcpServerSocketProperties.q());
            }
            serverSocket.setReuseAddress(tcpServerSocketProperties.k());
            InetSocketAddress inetSocketAddress = this.a(this.cu, this.cu.getTcpServerSocketProperties().o());
            serverSocket.bind(inetSocketAddress, tcpServerSocketProperties.r());
            return serverSocket;
        }
        catch (Exception exception) {
            throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_002, "Could not create TCP listener socket", (Throwable)exception);
        }
    }

    private Socket at() throws cz.integsoft.mule.ipm.api.exception.ConnectionException, IOException {
        try {
            return this.ct.accept();
        }
        catch (IOException iOException) {
            if (!this.ct.isClosed()) {
                throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_003, "An error occurred while listening for new TCP connections", (Throwable)iOException);
            }
            cs.debug("TCP listener socket has been gracefully closed");
            throw iOException;
        }
    }

    private InetSocketAddress a(TcpListenerConfig tcpListenerConfig, boolean bl) throws cz.integsoft.mule.ipm.api.exception.ConnectionException {
        InetSocketAddress inetSocketAddress = tcpListenerConfig.getInetSocketAddress();
        if (inetSocketAddress.isUnresolved() && bl) {
            throw new cz.integsoft.mule.ipm.api.exception.ConnectionException(ProxyErrorCode.IPM_INC_001, MessageFormat.format("Failed to resolve host {0}!", tcpListenerConfig.getHost()));
        }
        return inetSocketAddress;
    }

    public void initialise() throws InitialisationException {
        if (this.cu.getTlsContext() != null && !this.cu.getTlsContext().isKeyStoreConfigured()) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.cu.getTlsContext());
    }
}

