/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.api.util;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.CounterException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolBoxModuleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolBoxModuleUtils.class);

    private ToolBoxModuleUtils() {
    }

    public static Charset getDefaultEncoding() {
        if (System.getProperty("mule.encoding") != null) {
            return Charset.forName(System.getProperty("mule.encoding"));
        }
        return Charset.defaultCharset();
    }

    public static boolean isInsideErrorHandler(ComponentLocation location) {
        if (location == null) {
            return false;
        }
        return location.getParts().parallelStream().anyMatch(p -> p.getPartIdentifier().isPresent() && TypedComponentIdentifier.ComponentType.ERROR_HANDLER.equals((Object)((TypedComponentIdentifier)p.getPartIdentifier().get()).getType()));
    }

    public static long parseOffset(String data) {
        try {
            return Long.parseLong(data);
        }
        catch (NumberFormatException e) {
            throw new CounterException(ToolBoxModuleErrorCode.ITM_CNT_001, MessageFormat.format("Failed to parse offset from {0}! {1}", data, e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

