/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.config;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.InitializationException;
import cz.integsoft.mule.itm.api.util.ToolBoxModuleUtils;
import cz.integsoft.mule.itm.internal.component.OffsetFileStore;
import cz.integsoft.mule.itm.internal.operation.FileCounterOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={FileCounterOperation.class})
@Configuration(name="file-counter-config")
public class FileCounterConfig
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCounterConfig.class);
    @Inject
    private OffsetFileStore fileStore;
    @RefName
    private String configName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="#[mule.home default '.' ++ '/conf/' ++ app.name ++ '-counter.log']")
    @Alias(value="file-name")
    @Placement(tab="General", order=1)
    private String counterFilename;
    private Path counterPath;

    public String getCounterFilename() {
        return this.counterFilename;
    }

    public Path getCounterPath() {
        return this.counterPath;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileCounterConfig [counterFilename=");
        builder.append(this.counterFilename);
        builder.append("]");
        return builder.toString();
    }

    public void initialise() throws InitialisationException {
        LOGGER.info("Initializing config with name {}", (Object)this.configName);
        this.counterPath = Paths.get(this.counterFilename, new String[0]).normalize();
        if (Files.notExists(this.counterPath, new LinkOption[0])) {
            LOGGER.warn("File counter file {} does not exist, so creating one with zero offset.", (Object)this.counterPath.toString());
            try {
                Files.createDirectories(this.counterPath.getParent(), new FileAttribute[0]);
                this.counterPath = Files.createFile(this.counterPath, new FileAttribute[0]);
                this.fileStore.write(this.counterPath, "0");
            }
            catch (IOException e) {
                throw new InitializationException(ToolBoxModuleErrorCode.ITM_ANY_002, MessageFormat.format("Failed to create file counter {0}!", this.counterPath.toString()), (Throwable)e);
            }
        } else {
            Long offset = ToolBoxModuleUtils.parseOffset(this.fileStore.read(this.counterPath));
            LOGGER.info("Initializing config with name {} and using already specified offset of {}", (Object)this.configName, (Object)offset);
        }
        LOGGER.info("Initializing config with name {} done", (Object)this.configName);
    }
}

