/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.operation;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.CacheException;
import cz.integsoft.mule.itm.api.exception.CacheNotFoundException;
import cz.integsoft.mule.itm.internal.operation.CacheManagerDelegate;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.Registry;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class CacheDelegate {
    private final CacheManager cacheManager;
    private Registry registry;

    public CacheDelegate(CacheManagerDelegate cacheManagerDelegate) {
        Objects.requireNonNull(cacheManagerDelegate.getCacheManager(), "The cache manager must not be null!");
        this.cacheManager = cacheManagerDelegate.getCacheManager();
    }

    public CacheDelegate(Registry registry, String cacheManagerName) {
        Objects.requireNonNull(cacheManagerName, "The cache manager name must not be null!");
        this.registry = registry;
        this.cacheManager = this.getCacheManagerOrThrow(cacheManagerName);
    }

    public void clear(String cacheName) {
        this.getCacheOrhrow(cacheName).clear();
    }

    public Object get(String cacheName, Object key) {
        Cache cache = this.getCacheOrhrow(cacheName);
        try {
            Cache.ValueWrapper wrapper = cache.get(key);
            if (wrapper == null) {
                return null;
            }
            return wrapper.get();
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_003, MessageFormat.format("Problem occurred while getting value from the cache ''{0}'' under key {1}. {2}", cacheName, key, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public <T> T get(String cacheName, Object key, Class<T> clazz) {
        Cache cache = this.getCacheOrhrow(cacheName);
        try {
            Object value = cache.get(key, clazz);
            return (T)value;
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_003, MessageFormat.format("Problem occurred while getting value from the cache ''{0}'' under key {1}. {2}", cacheName, key, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public <T> Set<T> getAllKeys(String cacheName) {
        Cache cache = this.getCacheOrhrow(cacheName);
        try {
            Map nativeCache = (Map)cache.getNativeCache();
            return nativeCache.keySet();
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_008, MessageFormat.format("Problem occurred while getting all keys from the cache ''{0}''. {1}", cacheName, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void evict(String cacheName, Object key) {
        Cache cache = this.getCacheOrhrow(cacheName);
        try {
            cache.evict(key);
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_004, MessageFormat.format("Problem occurred while removing value from the cache ''{0}'' under key {1}. {2}", cacheName, key, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void put(String cacheName, Object key, Object value) {
        Cache cache = this.getCacheOrhrow(cacheName);
        try {
            cache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_005, MessageFormat.format("Problem occurred while storing value in the cache ''{0}'' under key {1}. {2}", cacheName, key, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public Object putIfAbsent(String cacheName, Object key, Object value) {
        Cache cache = this.getCacheOrhrow(cacheName);
        try {
            Cache.ValueWrapper wrapper = cache.putIfAbsent(key, value);
            if (wrapper == null) {
                return null;
            }
            return wrapper.get();
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_005, MessageFormat.format("Problem occurred while storing value in the cache ''{0}'' under key {1}. {2}", cacheName, key, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private Cache getCacheOrhrow(String cacheName) {
        try {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                throw new CacheNotFoundException(ToolBoxModuleErrorCode.ITM_CACHE_001, MessageFormat.format("The cache ''{0}'' was not found!", cacheName));
            }
            return cache;
        }
        catch (Exception e) {
            throw new CacheNotFoundException(ToolBoxModuleErrorCode.ITM_CACHE_002, MessageFormat.format("Problem occurred while getting the cache ''{0}''. {1}", cacheName, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private CacheManager getCacheManagerOrThrow(String cacheManagerName) {
        try {
            Optional cmOpt = this.registry.lookupByName(cacheManagerName);
            if (!cmOpt.isPresent()) {
                throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_007, MessageFormat.format("The cache manager ''{0}'' was not found!", cacheManagerName));
            }
            return (CacheManager)cmOpt.get();
        }
        catch (Exception e) {
            throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_007, MessageFormat.format("Problem occurred while fetching the cache manager ''{0}''. {1}", cacheManagerName, e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

