/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.operation;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.CacheException;
import cz.integsoft.mule.itm.internal.config.CacheConfig;
import cz.integsoft.mule.itm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.itm.internal.metadata.JavaMetadataResolver;
import cz.integsoft.mule.itm.internal.operation.CacheDelegate;
import cz.integsoft.mule.itm.internal.parameter.ClearCacheParameters;
import cz.integsoft.mule.itm.internal.parameter.EvictFromCacheParameters;
import cz.integsoft.mule.itm.internal.parameter.GetAllKeysCacheParameters;
import cz.integsoft.mule.itm.internal.parameter.GetFromCacheParameters;
import cz.integsoft.mule.itm.internal.parameter.PutToCacheParameters;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheOperation.class);

    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="cache-clear")
    @Throws(value={GenericErrorTypeProvider.class})
    public void clear(@Config CacheConfig config, @ParameterGroup(name="Cache parameters") ClearCacheParameters parameters) {
        CacheDelegate delegate = new CacheDelegate(config.getCacheManagerDelegate());
        LOGGER.debug("Clearing cache {}", (Object)parameters.getCacheName());
        delegate.clear(parameters.getCacheName());
    }

    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="cache-evict")
    @Throws(value={GenericErrorTypeProvider.class})
    public void evict(@Config CacheConfig config, @ParameterGroup(name="Cache parameters") EvictFromCacheParameters parameters) {
        CacheDelegate delegate = new CacheDelegate(config.getCacheManagerDelegate());
        LOGGER.debug("Removing from cache {} key {}", (Object)parameters.getCacheName(), parameters.getKey());
        delegate.evict(parameters.getCacheName(), parameters.getKey());
    }

    @Execution(value=ExecutionType.BLOCKING)
    @MediaType(value="*/*", strict=false)
    @Alias(value="cache-get")
    @Throws(value={GenericErrorTypeProvider.class})
    @OutputResolver(output=JavaMetadataResolver.class)
    public Result<Object, Void> get(@Config CacheConfig config, @ParameterGroup(name="Cache parameters") GetFromCacheParameters parameters) {
        CacheDelegate delegate = new CacheDelegate(config.getCacheManagerDelegate());
        LOGGER.debug("Getting value from cache {} under key {}", (Object)parameters.getCacheName(), parameters.getKey());
        Object value = null;
        if (StringUtils.isBlank((CharSequence)parameters.getClazz())) {
            value = delegate.get(parameters.getCacheName(), parameters.getKey());
        } else {
            Class<?> clazz = null;
            try {
                LOGGER.debug("Loading class from {}", (Object)parameters.getClazz());
                clazz = Class.forName(parameters.getClazz());
            }
            catch (ClassNotFoundException e) {
                throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_006, MessageFormat.format("Problem loading class type {0} while trying to get data from the cache ''{1}'': {2}", parameters.getClazz(), parameters.getCacheName(), e.getLocalizedMessage()), (Throwable)e);
            }
            value = delegate.get(parameters.getCacheName(), parameters.getKey(), clazz);
        }
        Result.Builder responseBuilder = Result.builder();
        return responseBuilder.output(value).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).build();
    }

    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="cache-put")
    @Throws(value={GenericErrorTypeProvider.class})
    public void put(@Config CacheConfig config, @ParameterGroup(name="Cache parameters") PutToCacheParameters parameters) {
        CacheDelegate delegate = new CacheDelegate(config.getCacheManagerDelegate());
        LOGGER.debug("Adding to the cache {} key: {} value: {}", new Object[]{parameters.getCacheName(), parameters.getKey(), parameters.getValue()});
        delegate.put(parameters.getCacheName(), parameters.getKey(), parameters.getValue());
    }

    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="cache-put-if-absent")
    @Throws(value={GenericErrorTypeProvider.class})
    @OutputResolver(output=JavaMetadataResolver.class)
    public Result<Object, Void> putIfAbsent(@Config CacheConfig config, @ParameterGroup(name="Cache parameters") PutToCacheParameters parameters) {
        CacheDelegate delegate = new CacheDelegate(config.getCacheManagerDelegate());
        LOGGER.debug("Adding to the cache {} key: {} value: {}", new Object[]{parameters.getCacheName(), parameters.getKey(), parameters.getValue()});
        Object oldValue = delegate.putIfAbsent(parameters.getCacheName(), parameters.getKey(), parameters.getValue());
        Result.Builder responseBuilder = Result.builder();
        return responseBuilder.output(oldValue).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).build();
    }

    @Execution(value=ExecutionType.BLOCKING)
    @MediaType(value="*/*", strict=false)
    @Alias(value="cache-get-all-keys")
    @Throws(value={GenericErrorTypeProvider.class})
    @OutputResolver(output=JavaMetadataResolver.class)
    public Result<Object, Void> getAllKeys(@Config CacheConfig config, @ParameterGroup(name="Cache parameters") GetAllKeysCacheParameters parameters) {
        CacheDelegate delegate = new CacheDelegate(config.getCacheManagerDelegate());
        LOGGER.debug("Getting all keys from cache {}", (Object)parameters.getCacheName());
        Set value = delegate.getAllKeys(parameters.getCacheName());
        Result.Builder responseBuilder = Result.builder();
        return responseBuilder.output(value).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).build();
    }
}

