/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.operation;

import cz.integsoft.mule.itm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.itm.internal.operation.TransactionExecutor;
import cz.integsoft.mule.itm.internal.provider.TransactionIsolationLevelValueProvider;
import cz.integsoft.mule.itm.internal.provider.TransactionPropagationValueProvider;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringTransactionScope
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringTransactionScope.class);
    @Inject
    private Registry registry;
    private TransactionExecutor txExecutor;

    @Alias(value="spring-transaction")
    @Throws(value={GenericErrorTypeProvider.class})
    @MediaType(value="*/*")
    public void springTransaction(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="-1") int timeout, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="DEFAULT") @OfValues(value=TransactionIsolationLevelValueProvider.class) String isolation, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="REQUIRED") @OfValues(value=TransactionPropagationValueProvider.class) String propagation, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean readOnly, Chain operations, CompletionCallback<Object, Object> callback) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("In SpringTransactionScope with transaction manager: {}", (Object)this.txExecutor.getTransactionManager());
        }
        this.txExecutor.doInTransaction(timeout, readOnly, isolation, propagation, operations, callback);
    }

    public void initialise() throws InitialisationException {
        Optional txManagerOpt = this.registry.lookupByType(PlatformTransactionManager.class);
        if (!txManagerOpt.isPresent()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Missing Spring Transaction Manager bean: " + PlatformTransactionManager.class.getName())), (Initialisable)this);
        }
        this.txExecutor = new TransactionExecutor((PlatformTransactionManager)txManagerOpt.get());
    }
}

