/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.operation;

import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionExecutor.class);
    private final PlatformTransactionManager transactionManager;

    public TransactionExecutor(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void doInTransaction(int timeout, boolean readOnly, String isolation, String propagation, final Chain operations, final CompletionCallback<Object, Object> callback) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.setTimeout(timeout);
        template.setIsolationLevelName("ISOLATION_" + isolation);
        template.setPropagationBehaviorName("PROPAGATION_" + propagation);
        template.setReadOnly(readOnly);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus txStatus) {
                operations.process(result -> {
                    LOGGER.debug("SpringTransactionScope completed successfully.");
                    callback.success(result);
                }, (error, previous) -> {
                    LOGGER.error("SpringTransactionScope failed: {}", (Object)error.getMessage());
                    txStatus.setRollbackOnly();
                    Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
                    LOGGER.debug("Mule transaction: {}", (Object)currentTx);
                    if (currentTx != null) {
                        try {
                            if (!currentTx.isRollbackOnly()) {
                                currentTx.setRollbackOnly();
                            }
                        }
                        catch (TransactionException e) {
                            LOGGER.warn("Failed to mark Mule transaction {} as for rollback only", (Object)currentTx);
                        }
                    }
                    callback.error(error);
                });
            }
        });
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

