/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.xpath;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class XPathNamespaceContext
implements NamespaceContext {
    private final BiMap<String, String> prefixToNamespaceMap;

    public XPathNamespaceContext(Map<String, String> prefixToNamespaceMap) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        if (prefixToNamespaceMap != null) {
            namespaces.putAll(prefixToNamespaceMap);
        }
        this.loadDefaultNamespaces(namespaces);
        this.prefixToNamespaceMap = ImmutableBiMap.copyOf(namespaces);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null!");
        }
        return (String)this.prefixToNamespaceMap.get((Object)prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return (String)this.prefixToNamespaceMap.inverse().get((Object)namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.prefixToNamespaceMap.keySet().iterator();
    }

    private void loadDefaultNamespaces(Map<String, String> namespaces) {
        this.putIfAbsent(namespaces, "", "");
        this.putIfAbsent(namespaces, "xml", "http://www.w3.org/XML/1998/namespace");
        this.putIfAbsent(namespaces, "xs", "http://www.w3.org/2001/XMLSchema");
        this.putIfAbsent(namespaces, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private void putIfAbsent(Map<String, String> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

