/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.api;

import cz.integsoft.mule.license.api.LicenseManager;
import cz.integsoft.mule.license.api.LicenseManagerHolder;
import cz.integsoft.mule.license.api.LicenseManagerProvider;
import cz.integsoft.mule.license.api.exception.InvalidLicenseException;
import cz.integsoft.mule.license.api.exception.LicenseManagementException;
import cz.integsoft.mule.license.api.exception.MaxCallsReachedException;
import cz.integsoft.mule.license.api.license.License;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenseHelper
implements Disposable,
Initialisable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractLicenseHelper.class);
    protected LicenseManager licenseManager;
    protected License currentLicense;
    protected String applicationName;
    protected String componentName;
    protected String componentVersion;
    @Inject
    private Registry a;

    public void validateLicense() throws InvalidLicenseException {
        if (this.currentLicense == null) {
            throw new InvalidLicenseException("License is required, but none was found!");
        }
        this.currentLicense.checkValid();
    }

    public void incCall() throws MaxCallsReachedException, LicenseManagementException {
        this.licenseManager.incCall(this.currentLicense, this.componentName, this.componentVersion, this.applicationName);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public abstract void dispose();

    public void initialise() throws InitialisationException {
        this.licenseManager = LicenseManagerHolder.getLicenseManager();
        if (this.licenseManager == null && this.a != null) {
            LOGGER.info("Trying to load license manager in Spring context...");
            Optional optional = this.a.lookupByName("licenseManagerProvider");
            if (optional.isPresent()) {
                LOGGER.debug("Found Spring License Manager Provider: {}, class: {}", optional.get(), (Object)((LicenseManagerProvider)optional.get()).getClass().getName());
                this.licenseManager = ((LicenseManagerProvider)optional.get()).getLicenseManager();
                LOGGER.info("Found license manager in Spring context: {}", (Object)this.licenseManager);
            }
        }
        if (this.licenseManager == null) {
            LOGGER.warn("Failed to fetch license manager!");
        } else {
            LOGGER.info("Fetched license manager {}", (Object)this.licenseManager);
        }
    }
}

