/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.api;

import cz.integsoft.mule.license.api.SecurityService;
import cz.integsoft.mule.license.api.Utils;
import cz.integsoft.mule.license.api.exception.InvalidLicenseException;
import cz.integsoft.mule.license.api.license.AbstractLicense;
import cz.integsoft.mule.license.api.license.License;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.text.MessageFormat;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;

public class LicenseReader {
    private static final Logger a = LoggerFactory.getLogger(LicenseReader.class);
    private PublicKey b;
    private String c;
    private String d;

    public LicenseReader(PublicKey publicKey, String string, String string2) {
        this.b = publicKey;
        this.c = string;
        this.d = string2;
    }

    public License read(Resource resource) throws InvalidLicenseException, GeneralSecurityException {
        String[] stringArray;
        Object object;
        if (resource instanceof FileSystemResource) {
            object = (FileSystemResource)resource;
            stringArray = object.getFile().toPath();
            this.a((Path)stringArray);
        }
        if (resource instanceof PathResource) {
            object = (PathResource)resource;
            stringArray = null;
            try {
                stringArray = object.getFile().toPath();
            }
            catch (IOException iOException) {
                new IllegalStateException("Failed to get license file!", iOException);
            }
            this.a((Path)stringArray);
        }
        a.info("Reading license {}", (Object)resource);
        try {
            object = new String(IOUtils.toByteArray((InputStream)resource.getInputStream())).replaceAll("[\\n]", "");
            stringArray = Utils.parseLicenseFileStructure((String)object);
            String string = stringArray[0].replace("Version:", "");
            a.info("License version: {}", (Object)string);
            String string2 = ((String)object).substring(0, ((String)object).lastIndexOf("|") + 1);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(this.b);
            signature.update(string2.getBytes("UTF-8"));
            byte[] byArray = Base64.getDecoder().decode(stringArray[5]);
            boolean bl = signature.verify(byArray);
            if (!bl) {
                throw new InvalidLicenseException(MessageFormat.format("Provided license failed PKI signature verification! Resource: {0}", resource));
            }
            return SecurityService.decryptLicense(stringArray[4], this.c, this.d, AbstractLicense.class);
        }
        catch (Exception exception) {
            throw new InvalidLicenseException(MessageFormat.format("Could not read license data from {0}! {1}", resource, exception.getLocalizedMessage()), exception);
        }
    }

    private void a(Path path) throws InvalidLicenseException {
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new InvalidLicenseException(MessageFormat.format("Provided license file {0} does not exist or is a directory!", path));
        }
    }
}

