/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.integsoft.mule.license.api.Utils;
import cz.integsoft.mule.license.api.license.License;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class SecurityService {
    private static final int a = 65536;
    private static final int b = 256;
    private static final int c = 16;

    private SecurityService() {
    }

    public static KeyPair loadKeyPair(Path path, String string, String string2, String string3, String string4) throws GeneralSecurityException, IOException {
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(MessageFormat.format("Unable to file certificate file {0}!", path));
        }
        KeyStore keyStore = KeyStore.getInstance(string);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            keyStore.load(inputStream, string2.toCharArray());
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string3.toCharArray());
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string4, passwordProtection);
            Certificate certificate = keyStore.getCertificate(string4);
            PublicKey publicKey = certificate.getPublicKey();
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
    }

    public static KeyPair loadKeyPair(InputStream inputStream, String string, String string2, String string3, String string4) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(string);
        keyStore.load(inputStream, string2.toCharArray());
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string3.toCharArray());
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string4, passwordProtection);
        Certificate certificate = keyStore.getCertificate(string4);
        PublicKey publicKey = certificate.getPublicKey();
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        return new KeyPair(publicKey, privateKey);
    }

    public static PublicKey loadPublicKey(Path path, String string, String string2, String string3, String string4) throws GeneralSecurityException, IOException {
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(MessageFormat.format("Unable to file certificate file {0}!", path));
        }
        return SecurityService.loadPublicKey(Files.newInputStream(path, new OpenOption[0]), string, string2, string3, string4);
    }

    public static PublicKey loadPublicKey(InputStream inputStream, String string, String string2, String string3, String string4) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(string);
        keyStore.load(inputStream, string2.toCharArray());
        Certificate certificate = keyStore.getCertificate(string4);
        if (certificate == null) {
            throw new IllegalStateException(MessageFormat.format("Could not find public key under alias {0} in the keystore!", string4));
        }
        return certificate.getPublicKey();
    }

    public static String sign(String string, PrivateKey privateKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(string.getBytes("UTF-8"));
        byte[] byArray = signature.sign();
        return Base64.getEncoder().encodeToString(byArray);
    }

    public static String encryptLicense(License license, String string, String string2) throws GeneralSecurityException, JsonProcessingException {
        byte[] byArray = new byte[16];
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), string2.getBytes(), 65536, 256);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        ObjectMapper objectMapper = Utils.getObjectMapper();
        return Base64.getEncoder().encodeToString(cipher.doFinal(objectMapper.writeValueAsBytes((Object)license)));
    }

    public static License decryptLicense(String string, String string2, String string3, Class<? extends License> clazz) throws GeneralSecurityException, IOException {
        byte[] byArray = new byte[16];
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string2.toCharArray(), string3.getBytes(), 65536, 256);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] byArray2 = cipher.doFinal(Base64.getDecoder().decode(string));
        ObjectMapper objectMapper = Utils.getObjectMapper();
        return (License)objectMapper.readValue(byArray2, clazz);
    }
}

