/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.api;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import cz.integsoft.mule.license.api.exception.InvalidLicenseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.regex.Pattern;

public final class Utils {
    private Utils() {
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static String nan(String string) {
        if (string == null || string.trim().isEmpty()) {
            return "N/A";
        }
        return string;
    }

    public static String[] parseLicenseFileStructure(String string) throws InvalidLicenseException {
        if (string == null || string.isEmpty()) {
            throw new InvalidLicenseException("Invalid data structure. Is it a license file?");
        }
        String[] stringArray = string.split(Pattern.quote("|"));
        if (stringArray == null || stringArray.length != 6) {
            throw new InvalidLicenseException("Invalid data structure. Is it a license file?");
        }
        return stringArray;
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        return objectMapper;
    }

    public static boolean isBetween(Instant instant, Instant instant2, Instant instant3) {
        if (instant == null) {
            throw new IllegalArgumentException("Current time cannot be null");
        }
        if (instant2 == null || instant3 == null) {
            throw new IllegalArgumentException("Time range cannot be null");
        }
        if (instant.equals(instant2) || instant.equals(instant3)) {
            return true;
        }
        if (instant3.isBefore(instant2)) {
            return instant.isAfter(instant3) && instant.isBefore(instant2);
        }
        return instant.isAfter(instant2) && instant.isBefore(instant3);
    }

    public static String getBasicHeader(String string, String string2) {
        if (string2 != null) {
            return "Basic " + Base64.getEncoder().encodeToString((string + ":" + string2).getBytes());
        }
        return "Basic " + Base64.getEncoder().encodeToString(string.getBytes());
    }
}

