/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.api.license;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import cz.integsoft.mule.license.api.license.DemoLicense;
import cz.integsoft.mule.license.api.license.License;
import cz.integsoft.mule.license.api.license.LicenseType;
import cz.integsoft.mule.license.api.license.LicenseUsage;
import cz.integsoft.mule.license.api.license.OfflineLicense;
import cz.integsoft.mule.license.api.license.OnlineLicense;
import cz.integsoft.mule.license.api.license.StartupLicense;
import java.time.Instant;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=OfflineLicense.class, name="offline"), @JsonSubTypes.Type(value=OnlineLicense.class, name="online"), @JsonSubTypes.Type(value=DemoLicense.class, name="demo"), @JsonSubTypes.Type(value=StartupLicense.class, name="startup")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractLicense
implements License {
    @JsonProperty(required=true)
    protected String version;
    @JsonProperty(required=true)
    protected LicenseUsage licenseUsage;
    @JsonProperty(required=true)
    protected String id;
    @JsonProperty(required=true)
    protected int count = 1;
    @JsonProperty
    protected Instant validTo;
    @JsonProperty(required=true)
    protected Instant generatedAt;
    @JsonProperty(required=true)
    protected LicenseType type;
    @JsonProperty
    protected String issuedFor;
    @JsonProperty
    protected String userName;
    @JsonProperty
    protected String userEmail;

    public AbstractLicense(String string, Instant instant, String string2, LicenseUsage licenseUsage) {
        this(string, string2, 1, instant, Instant.now(), licenseUsage, null, null, null);
    }

    public AbstractLicense(String string, String string2, int n, Instant instant, Instant instant2, LicenseUsage licenseUsage, String string3, String string4, String string5) {
        this.id = string;
        this.version = string2;
        this.count = n;
        this.validTo = instant;
        this.generatedAt = instant2 == null ? Instant.now() : instant2;
        this.licenseUsage = licenseUsage;
        this.issuedFor = string3;
        this.userName = string4;
        this.userEmail = string5;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Instant getValidTo() {
        return this.validTo;
    }

    @Override
    public String getIssuedFor() {
        return this.issuedFor;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getUserEmail() {
        return this.userEmail;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Instant getGeneratedAt() {
        return this.generatedAt;
    }

    @Override
    public LicenseType getType() {
        return this.type;
    }

    @Override
    public LicenseUsage getLicenseUsage() {
        return this.licenseUsage;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractLicense abstractLicense = (AbstractLicense)object;
        return Objects.equals(this.id, abstractLicense.id) && Objects.equals(this.version, abstractLicense.version);
    }
}

