/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.api.license;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import cz.integsoft.mule.license.api.Pair;
import cz.integsoft.mule.license.api.Utils;
import cz.integsoft.mule.license.api.exception.InvalidLicenseException;
import cz.integsoft.mule.license.api.license.AbstractLicense;
import cz.integsoft.mule.license.api.license.LicenseType;
import cz.integsoft.mule.license.api.license.LicenseUsage;
import cz.integsoft.mule.license.api.license.a;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.List;

public final class OfflineLicense
extends AbstractLicense {
    @JsonCreator
    public OfflineLicense(@JsonProperty(value="id") String string, @JsonProperty(value="version") String string2, @JsonProperty(value="validTo") Instant instant, @JsonProperty(value="licenseUsage") LicenseUsage licenseUsage) {
        super(string, instant, string2, licenseUsage);
        this.type = LicenseType.offline;
    }

    public OfflineLicense(String string, String string2, int n, Instant instant, Instant instant2, LicenseUsage licenseUsage) {
        super(string, string2, n, instant, instant2, licenseUsage, null, null, null);
        this.type = LicenseType.offline;
    }

    public OfflineLicense(String string, String string2, int n, Instant instant, Instant instant2, LicenseUsage licenseUsage, String string3, String string4, String string5) {
        super(string, string2, n, instant, instant2, licenseUsage, string3, string4, string5);
        this.type = LicenseType.offline;
    }

    @Override
    public String printLicense(List<Pair<String, String>> list) {
        return this.printLicense(80, list);
    }

    @Override
    public void printLicense(OutputStream outputStream, List<Pair<String, String>> list) throws IOException {
        this.printLicense(outputStream, 80, list);
    }

    @Override
    public String printLicense(int n, List<Pair<String, String>> list) {
        a a2 = new a(n);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            bl = true;
            stringBuilder.append('\n').append(a2.a());
            list.stream().forEach(pair -> stringBuilder.append(a2.a((String)pair.getFirst() + ": " + (String)pair.getSecond())));
            stringBuilder.append(a2.b());
        }
        if (!bl) {
            stringBuilder.append('\n').append(a2.a());
        }
        stringBuilder.append(a2.a("License ID: " + this.id)).append(a2.a("License is " + (this.isValid() ? "valid" : "invalid"))).append(a2.a("Number of licenses: " + this.count)).append(a2.a("Valid until: " + a2.a(Utils.toLocalDateTime(this.validTo)))).append(a2.a("Generated at: " + Utils.toLocalDateTime(this.generatedAt))).append(a2.a("License type: " + a2.a(this.type))).append(a2.a("License usage: " + a2.a(this.licenseUsage))).append(a2.a("Issued for: " + Utils.nan(this.issuedFor))).append(a2.a("User: " + Utils.nan(this.userName))).append(a2.a("User email: " + Utils.nan(this.userEmail)));
        stringBuilder.append(a2.a());
        return stringBuilder.toString();
    }

    @Override
    public void printLicense(OutputStream outputStream, int n, List<Pair<String, String>> list) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null!");
        }
        outputStream.write(this.printLicense(n, list).getBytes());
        outputStream.flush();
    }

    @Override
    @JsonIgnore
    public boolean isValid() {
        Instant instant = Instant.now();
        if (this.validTo != null && !Utils.isBetween(instant, this.generatedAt, this.validTo)) {
            return false;
        }
        if (this.count <= 0) {
            return false;
        }
        if (this.validTo != null && this.generatedAt.isAfter(this.validTo)) {
            return false;
        }
        return this.validTo == null || !Instant.now().isAfter(this.validTo);
    }

    @Override
    public void checkValid() throws InvalidLicenseException {
        if (this.count <= 0) {
            throw new InvalidLicenseException("License is invalid because the count is less or equal to zero!");
        }
        if (this.validTo != null && this.generatedAt.isAfter(this.validTo)) {
            throw new InvalidLicenseException("License is invalid because the validTo is before generatedAt!");
        }
        if (this.validTo != null && Instant.now().isAfter(this.validTo)) {
            throw new InvalidLicenseException(MessageFormat.format("License is invalid because it expired at {0}", Utils.toLocalDateTime(this.validTo)));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OfflineLicense [version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", licenseUsage=");
        stringBuilder.append((Object)this.licenseUsage);
        stringBuilder.append(", id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", generatedAt=");
        stringBuilder.append(this.generatedAt);
        stringBuilder.append(", type=");
        stringBuilder.append((Object)this.type);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

