/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.manager.api;

import cz.integsoft.mule.license.api.LicenseManager;
import cz.integsoft.mule.license.api.LicenseManagerHolder;
import cz.integsoft.mule.license.api.LicenseManagerProvider;
import cz.integsoft.mule.license.api.UrlResource;
import cz.integsoft.mule.license.api.exception.LicenseManagementException;
import cz.integsoft.mule.license.manager.internal.DefaultLicenseManager;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DefaultLicenseManagerProvider
implements LicenseManagerProvider,
ComponentBuildingDefinitionProvider {
    private static final Logger a = LoggerFactory.getLogger(DefaultLicenseManagerProvider.class);
    private static LicenseManager b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        a.debug("Initializing {}", (Object)this);
        Class<LicenseManager> clazz = LicenseManager.class;
        synchronized (LicenseManager.class) {
            if (b == null) {
                try {
                    Object object;
                    DefaultLicenseManager defaultLicenseManager = new DefaultLicenseManager("license-truststore.p12", "GDneu2V3Zs5YcByA", "GDneu2V3Zs5YcByA", "eye-pub", "42gbB5Kba7rwxJZa", "gmg35SV^x5)w$4$j");
                    String string = System.getProperty("integrationeye.licenses.url");
                    UrlResource urlResource = null;
                    if (string != null) {
                        if (string.toLowerCase().startsWith("classpath:")) {
                            urlResource = new ClassPathResource(string.replaceAll("classpath:", "").replaceAll("classpath*:", ""));
                        } else {
                            object = new URL(string);
                            urlResource = new UrlResource((URL)object);
                        }
                    } else {
                        object = Paths.get(System.getProperty("integrationeye.licenses.folder", System.getProperty("mule.home", ".") + File.separator + "conf/integrationeye-licenses"), new String[0]).normalize();
                        if (!Files.exists((Path)object, new LinkOption[0])) {
                            a.warn("Could not find licenses location {}, so continuing without any license.", object);
                        }
                        urlResource = new FileSystemResource((Path)object);
                    }
                    if (urlResource == null || !urlResource.exists()) {
                        a.warn("Could not find licenses location {}, so continuing without any license.", (Object)string);
                    } else {
                        try {
                            object = defaultLicenseManager.loadLicenses((Resource)urlResource);
                            if (object == null || object.isEmpty()) {
                                a.warn("No valid licenses found, so continuing without any license.");
                            }
                        }
                        catch (LicenseManagementException licenseManagementException) {
                            a.warn("Failed to load licenses!", (Throwable)licenseManagementException);
                        }
                    }
                    b = defaultLicenseManager;
                    LicenseManagerHolder.setLicenseManager((LicenseManager)defaultLicenseManager);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Failed to initialize license manager!", exception);
                }
            }
            a.debug("License manager is  already set to {}", (Object)b);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        return Collections.emptyList();
    }

    @PostConstruct
    public void load() {
        this.init();
    }

    @PreDestroy
    public void unload() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer.isRegistered(new ObjectName("cz.integsoft.integrationeye.license.manager:type=LicenseManager"))) {
            mBeanServer.unregisterMBean(new ObjectName("cz.integsoft.integrationeye.license.manager:type=LicenseManager"));
            mBeanServer.unregisterMBean(new ObjectName("cz.integsoft.integrationeye.license.pool:type=DemoLicensePool"));
            mBeanServer.unregisterMBean(new ObjectName("cz.integsoft.integrationeye.license.pool:type=StartupLicensePool"));
            mBeanServer.unregisterMBean(new ObjectName("cz.integsoft.integrationeye.license.pool:type=OfflineLicensePool"));
            mBeanServer.unregisterMBean(new ObjectName("cz.integsoft.integrationeye.license.pool:type=OnlineLicensePool"));
        }
    }

    public LicenseManager getLicenseManager() {
        return b;
    }
}

